/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Binary;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.engine.ImmutablePage;
import com.arcadedb.engine.PageId;
import com.arcadedb.engine.PaginatedComponentFile;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.NetworkProtocolException;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.FileContentResponse;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class FileContentRequest
extends HAAbstractCommand {
    private String databaseName;
    private int fileId;
    private int fromPageInclusive;
    private int toPageInclusive;
    private static final int CHUNK_MAX_PAGES = 10;

    public FileContentRequest() {
    }

    public FileContentRequest(String dbName, int fileId, int pageFromInclusive, int pageToInclusive) {
        this.databaseName = dbName;
        this.fileId = fileId;
        this.fromPageInclusive = pageFromInclusive;
        this.toPageInclusive = pageToInclusive;
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        ServerDatabase db = server.getServer().getDatabase(this.databaseName);
        ComponentFile file = db.getFileManager().getFile(this.fileId);
        if (file instanceof PaginatedComponentFile) {
            PaginatedComponentFile componentFile = (PaginatedComponentFile)file;
            int pageSize = componentFile.getPageSize();
            try {
                int totalPages = (int)(file.getSize() / (long)pageSize);
                Binary pagesContent = new Binary();
                AtomicInteger pages = new AtomicInteger(0);
                if (this.toPageInclusive == -1) {
                    this.toPageInclusive = totalPages - 1;
                }
                for (int i = this.fromPageInclusive; i <= this.toPageInclusive && pages.get() < 10; ++i) {
                    PageId pageId = new PageId((BasicDatabase)db, this.fileId, i);
                    ImmutablePage page = db.getPageManager().getImmutablePage(pageId, pageSize, false, false);
                    pagesContent.putByteArray(page.getContent().array(), pageSize);
                    pages.incrementAndGet();
                }
                boolean last = pages.get() > this.toPageInclusive;
                pagesContent.flip();
                return new FileContentResponse(this.databaseName, this.fileId, file.getFileName(), this.fromPageInclusive, pagesContent, pages.get(), last);
            }
            catch (IOException e) {
                throw new NetworkProtocolException("Cannot load pages", (Exception)e);
            }
        }
        LogManager.instance().log((Object)this, Level.SEVERE, "Cannot read not paginated file %s from the leader", (Object)file.getFileName());
        throw new NetworkProtocolException("Cannot read not paginated file " + file.getFileName() + " from the leader");
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.databaseName);
        stream.putInt(this.fileId);
        stream.putInt(this.fromPageInclusive);
        stream.putInt(this.toPageInclusive);
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        this.databaseName = stream.getString();
        this.fileId = stream.getInt();
        this.fromPageInclusive = stream.getInt();
        this.toPageInclusive = stream.getInt();
    }

    public String toString() {
        return "file(" + this.databaseName + " fileId=" + this.fileId + " fromPageInclusive=" + this.fromPageInclusive + " fromPageInclusive" + this.toPageInclusive + ")";
    }
}

