/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.network.binary.NetworkProtocolException;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ServerDatabase;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.DatabaseStructureResponse;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.utility.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class DatabaseStructureRequest
extends HAAbstractCommand {
    private String databaseName;

    public DatabaseStructureRequest() {
    }

    public DatabaseStructureRequest(String dbName) {
        this.databaseName = dbName;
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        ServerDatabase db = server.getServer().getOrCreateDatabase(this.databaseName);
        File file = new File(db.getDatabasePath() + File.separator + "schema.json");
        try {
            String schemaJson;
            if (file.exists()) {
                try (FileInputStream fis = new FileInputStream(file);){
                    schemaJson = FileUtils.readStreamAsString((InputStream)fis, (String)db.getSchema().getEncoding());
                }
            } else {
                schemaJson = "{}";
            }
            HashMap<Integer, String> fileNames = new HashMap<Integer, String>();
            for (ComponentFile f : db.getFileManager().getFiles()) {
                if (f == null) continue;
                fileNames.put(f.getFileId(), f.getFileName());
            }
            long lastLogNumber = server.getReplicationLogFile().getLastMessageNumber();
            return new DatabaseStructureResponse(schemaJson, fileNames, lastLogNumber);
        }
        catch (IOException e) {
            throw new NetworkProtocolException("Error on reading schema json file", (Exception)e);
        }
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.databaseName);
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        this.databaseName = stream.getString();
    }

    public String toString() {
        return "dbstructure(" + this.databaseName + ")";
    }
}

