/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.security.credential;

import com.arcadedb.server.security.ServerSecurityException;
import com.arcadedb.server.security.credential.CredentialsValidator;
import java.util.Random;
import java.util.UUID;

public class DefaultCredentialsValidator
implements CredentialsValidator {
    protected int userMinLength = 4;
    protected int userMaxLength = 256;
    protected int passwordMinLength = 8;
    protected int passwordMaxLength = 256;

    @Override
    public void validateCredentials(String userName, String userPassword) throws ServerSecurityException {
        if (userName == null || userName.isEmpty()) {
            throw new ServerSecurityException("Empty user name");
        }
        if (userName.length() < this.userMinLength) {
            throw new ServerSecurityException("User name too short (<" + this.userMinLength + " characters)");
        }
        if (userName.length() > this.userMaxLength) {
            throw new ServerSecurityException("User name too long (>" + this.userMaxLength + " characters)");
        }
        if (userPassword == null || userPassword.isEmpty()) {
            throw new ServerSecurityException("Empty user password");
        }
        if (userPassword.length() < this.passwordMinLength) {
            throw new ServerSecurityException("User password too short (<" + this.passwordMinLength + " characters)");
        }
        if (userPassword.length() > this.passwordMaxLength) {
            throw new ServerSecurityException("User password too long (>" + this.passwordMaxLength + " characters)");
        }
    }

    @Override
    public String generateRandomPassword() {
        Object password = UUID.randomUUID().toString().substring(0, 8);
        for (int i = 0; i < ((String)password).length() - 1; ++i) {
            char c = ((String)password).charAt(i);
            if (!Character.isLetter(c) || new Random().nextInt(2) != 0) continue;
            password = ((String)password).substring(0, i) + Character.toUpperCase(c) + ((String)password).substring(i + 1);
        }
        return password;
    }
}

