/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.handler;

import com.arcadedb.database.Database;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.http.HttpServer;
import com.arcadedb.server.http.handler.AbstractQueryHandler;
import com.arcadedb.server.http.handler.ExecutionResponse;
import com.arcadedb.server.security.ServerSecurityUser;
import io.micrometer.core.instrument.Metrics;
import io.undertow.server.HttpServerExchange;
import java.io.UnsupportedEncodingException;

public class GetQueryHandler
extends AbstractQueryHandler {
    public GetQueryHandler(HttpServer httpServer) {
        super(httpServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResponse execute(HttpServerExchange exchange, ServerSecurityUser user, Database database) throws UnsupportedEncodingException {
        String limitPar;
        String text = this.getQueryParameter(exchange, "command");
        if (text == null) {
            return new ExecutionResponse(400, "{ \"error\" : \"Command text is null\"}");
        }
        String language = this.getQueryParameter(exchange, "language");
        if (language == null) {
            return new ExecutionResponse(400, "{ \"error\" : \"Language is null\"}");
        }
        String serializer = this.getQueryParameter(exchange, "serializer");
        if (serializer == null) {
            serializer = "record";
        }
        int limit = (limitPar = this.getQueryParameter(exchange, "limit")) == null ? 20000 : Integer.parseInt(limitPar);
        JSONObject response = new JSONObject();
        try {
            ResultSet qResult = database.query(language, text, new Object[0]);
            this.serializeResultSet(database, serializer, limit, response, qResult);
        }
        finally {
            Metrics.counter((String)"http.query", (String[])new String[0]).increment();
        }
        return new ExecutionResponse(200, response.toString());
    }

    @Override
    protected boolean requiresTransaction() {
        return false;
    }
}

