/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Document;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.RID;
import com.arcadedb.database.Record;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.VertexInternal;
import com.arcadedb.query.sql.executor.IteratorResultSet;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultInternal;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import java.util.ArrayList;

public class CommandForwardResponse
extends HAAbstractCommand {
    private ResultSet resultset;
    private DatabaseInternal database;

    public CommandForwardResponse() {
    }

    public CommandForwardResponse(DatabaseInternal database, ResultSet resultset) {
        this.database = database;
        this.resultset = resultset;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.database.getName());
        while (this.resultset.hasNext()) {
            Result next = this.resultset.next();
            stream.putByte((byte)1);
            if (next.isVertex()) {
                VertexInternal v = (VertexInternal)next.getVertex().get();
                stream.putString(v.getIdentity().toString());
                stream.putBytes(this.database.getSerializer().serializeVertex(this.database, v).getContent());
                continue;
            }
            if (next.isEdge()) {
                Edge e = (Edge)next.getEdge().get();
                stream.putString(e.getIdentity().toString());
                stream.putBytes(this.database.getSerializer().serializeEdge(this.database, e).getContent());
                continue;
            }
            if (next.isElement()) {
                Document d = (Document)next.getElement().get();
                stream.putString(d.getIdentity().toString());
                stream.putBytes(this.database.getSerializer().serializeDocument(this.database, d).getContent());
                continue;
            }
            stream.putString("");
            stream.putString(next.toJSON().toString());
        }
        stream.putByte((byte)0);
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        String databaseName = stream.getString();
        this.database = server.getDatabase(databaseName);
        Binary buffer = new Binary();
        ArrayList<ResultInternal> list = new ArrayList<ResultInternal>();
        while (stream.getByte() == 1) {
            RID rid;
            String ridAsString = stream.getString();
            RID rID = rid = ridAsString.isEmpty() ? null : new RID((BasicDatabase)this.database, ridAsString);
            if (rid == null) {
                JSONObject json = new JSONObject(stream.getString());
                list.add(new ResultInternal(json.toMap()));
                continue;
            }
            buffer.clear();
            buffer.putByteArray(stream.getBytes());
            buffer.flip();
            DocumentType t = this.database.getSchema().getTypeByBucketId(rid.getBucketId());
            Record record = this.database.getRecordFactory().newImmutableRecord((Database)this.database, t, rid, buffer.copyOfContent(), null);
            list.add(new ResultInternal((Identifiable)record));
        }
        this.resultset = new IteratorResultSet(list.iterator());
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        server.receivedResponseFromForward(messageNumber, this.resultset, null);
        return null;
    }

    public String toString() {
        return "command-forward-response";
    }
}

