/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server;

import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.utility.SoftThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class DefaultConsoleReader {
    private final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, DatabaseFactory.getDefaultCharset()));

    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (IOException ignore) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readPassword() {
        if (System.console() == null) {
            return this.readLine();
        }
        System.out.print(" ");
        EraserThread et = new EraserThread();
        et.start();
        try {
            String string = this.reader.readLine();
            return string;
        }
        catch (IOException ignore) {
            String string = null;
            return string;
        }
        finally {
            et.sendShutdown();
        }
    }

    private static class EraserThread
    extends SoftThread {
        public EraserThread() {
            super("ServerConsoleReader");
        }

        protected void execute() throws Exception {
            System.out.print("\b*");
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

