/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.ws;

import com.arcadedb.database.Record;
import com.arcadedb.event.AfterRecordCreateListener;
import com.arcadedb.event.AfterRecordDeleteListener;
import com.arcadedb.event.AfterRecordUpdateListener;
import com.arcadedb.server.http.ws.ChangeEvent;
import com.arcadedb.server.http.ws.DatabaseEventWatcherThread;

public class WebSocketEventListener
implements AfterRecordCreateListener,
AfterRecordUpdateListener,
AfterRecordDeleteListener {
    private final DatabaseEventWatcherThread watcherThread;

    public WebSocketEventListener(DatabaseEventWatcherThread watcherThread) {
        this.watcherThread = watcherThread;
    }

    public void onAfterCreate(Record record) {
        this.watcherThread.push(new ChangeEvent(ChangeEvent.TYPE.CREATE, record));
    }

    public void onAfterUpdate(Record record) {
        this.watcherThread.push(new ChangeEvent(ChangeEvent.TYPE.UPDATE, record));
    }

    public void onAfterDelete(Record record) {
        this.watcherThread.push(new ChangeEvent(ChangeEvent.TYPE.DELETE, record));
    }
}

