/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.security;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.security.SecurityUser;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.security.ServerSecurityDatabaseUser;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ServerSecurityUser
implements SecurityUser {
    private final ArcadeDBServer server;
    private final JSONObject userConfiguration;
    private final String name;
    private Set<String> databasesNames;
    private String password;
    private final ConcurrentHashMap<String, ServerSecurityDatabaseUser> databaseCache = new ConcurrentHashMap();

    public ServerSecurityUser(ArcadeDBServer server, JSONObject userConfiguration) {
        this.server = server;
        this.userConfiguration = userConfiguration;
        this.name = userConfiguration.getString("name");
        String string = this.password = userConfiguration.has("password") ? userConfiguration.getString("password") : null;
        if (userConfiguration.has("databases")) {
            JSONObject userDatabases = userConfiguration.getJSONObject("databases");
            this.databasesNames = Collections.unmodifiableSet(userDatabases.keySet());
        } else {
            this.databasesNames = Collections.emptySet();
        }
    }

    public ServerSecurityUser addDatabase(String databaseName, String[] groups) {
        HashSet<String> groupSet;
        HashSet<String> newDatabaseName = new HashSet<String>(this.databasesNames);
        JSONObject userDatabases = this.userConfiguration.getJSONObject("databases");
        if (userDatabases.has(databaseName)) {
            groupSet = new HashSet(userDatabases.getJSONArray(databaseName).toList());
            Collections.addAll(groupSet, groups);
        } else {
            groupSet = new HashSet<String>(Arrays.asList(groups));
            newDatabaseName.add(databaseName);
        }
        userDatabases.put(databaseName, (Object)new JSONArray(groupSet));
        newDatabaseName.add(databaseName);
        this.databasesNames = Collections.unmodifiableSet(newDatabaseName);
        return this;
    }

    public ServerSecurityDatabaseUser getDatabaseUser(Database database) {
        ServerSecurityDatabaseUser prev;
        String databaseName = database.getName();
        ServerSecurityDatabaseUser dbu = this.databaseCache.get(databaseName);
        if (dbu != null) {
            return dbu;
        }
        if (this.userConfiguration.has("databases")) {
            JSONObject userDatabases = this.userConfiguration.getJSONObject("databases");
            if (userDatabases.has(databaseName)) {
                dbu = this.registerDatabaseUser(this.server, database, databaseName);
            } else if (userDatabases.has("*")) {
                dbu = this.registerDatabaseUser(this.server, database, "*");
            }
        }
        if (dbu == null) {
            dbu = new ServerSecurityDatabaseUser(databaseName, this.name, new String[0]);
        }
        if ((prev = this.databaseCache.putIfAbsent(databaseName, dbu)) != null) {
            dbu = prev;
        }
        return dbu;
    }

    public JSONObject toJSON() {
        return this.userConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public ServerSecurityUser setPassword(String password) {
        this.password = password;
        this.userConfiguration.put("password", password);
        return this;
    }

    public Set<String> getAuthorizedDatabases() {
        return this.databasesNames;
    }

    public boolean canAccessToDatabase(String databaseName) {
        return this.databasesNames.contains("*") || this.databasesNames.contains(databaseName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerSecurityUser)) {
            return false;
        }
        ServerSecurityUser that = (ServerSecurityUser)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    private ServerSecurityDatabaseUser registerDatabaseUser(ArcadeDBServer server, Database database, String databasePattern) {
        JSONObject userDatabases = this.userConfiguration.getJSONObject("databases");
        List groupList = userDatabases.getJSONArray(databasePattern).toList();
        ServerSecurityDatabaseUser dbu = new ServerSecurityDatabaseUser(database.getName(), this.name, groupList.toArray(new String[groupList.size()]));
        ServerSecurityDatabaseUser prev = this.databaseCache.putIfAbsent(database.getName(), dbu);
        if (prev != null) {
            dbu = prev;
        }
        if (database != null && !"*".equals(database.getName())) {
            JSONObject databaseGroups = server.getSecurity().getDatabaseGroupsConfiguration(database.getName());
            dbu.updateDatabaseConfiguration(databaseGroups);
            dbu.updateFileAccess((DatabaseInternal)database, databaseGroups);
        }
        return dbu;
    }
}

