/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.ssl;

import com.arcadedb.server.http.ssl.KeystoreType;
import com.arcadedb.server.security.ServerSecurityException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.function.Supplier;

public class SslUtils {
    private static final String JAVAX_NET_SSL_KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String JAVAX_NET_SSL_TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";

    private SslUtils() {
    }

    public static KeyStore loadKeystoreFromStream(InputStream keystoreInputStream, String keystorePassword, String keystoreType) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (InputStream validatedInputStream = SslUtils.doValidateKeystoreStream(keystoreInputStream);){
            KeyStore keystore = KeyStore.getInstance(keystoreType);
            keystore.load(validatedInputStream, keystorePassword.toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
    }

    public static String getDefaultKeystoreTypeForKeystore(Supplier<KeystoreType> defaultSupplier) {
        return SslUtils.doGetDefaultKeystoreType(JAVAX_NET_SSL_KEYSTORE_TYPE, defaultSupplier);
    }

    public static String getDefaultKeystoreTypeForTruststore(Supplier<KeystoreType> defaultSupplier) {
        return SslUtils.doGetDefaultKeystoreType(JAVAX_NET_SSL_TRUSTSTORE_TYPE, defaultSupplier);
    }

    private static String doGetDefaultKeystoreType(String propertyName, Supplier<KeystoreType> defaultSupplier) {
        String keystoreTypeValue = System.getProperty(propertyName);
        if (keystoreTypeValue == null || keystoreTypeValue.isEmpty()) {
            return SslUtils.doValidateDefaultKeystoreSupplier(defaultSupplier).get().getKeystoreType();
        }
        return KeystoreType.getFromStringWithDefault(keystoreTypeValue, SslUtils.doValidateDefaultKeystoreSupplier(defaultSupplier).get()).getKeystoreType();
    }

    private static Supplier<KeystoreType> doValidateDefaultKeystoreSupplier(Supplier<KeystoreType> defaultSupplier) {
        if (defaultSupplier == null || defaultSupplier.get() == null) {
            throw new ServerSecurityException("Default key store supplier is not configured correctly");
        }
        return defaultSupplier;
    }

    private static InputStream doValidateKeystoreStream(InputStream keystoreInputStream) {
        if (keystoreInputStream == null) {
            throw new ServerSecurityException("Key store stream cannot be null");
        }
        return keystoreInputStream;
    }
}

