/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.exception.ConfigurationException;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.ReplicationMessage;
import com.arcadedb.server.ha.message.CommandForwardRequest;
import com.arcadedb.server.ha.message.CommandForwardResponse;
import com.arcadedb.server.ha.message.DatabaseAlignRequest;
import com.arcadedb.server.ha.message.DatabaseAlignResponse;
import com.arcadedb.server.ha.message.DatabaseChangeStructureRequest;
import com.arcadedb.server.ha.message.DatabaseChangeStructureResponse;
import com.arcadedb.server.ha.message.DatabaseStructureRequest;
import com.arcadedb.server.ha.message.DatabaseStructureResponse;
import com.arcadedb.server.ha.message.ErrorResponse;
import com.arcadedb.server.ha.message.FileContentRequest;
import com.arcadedb.server.ha.message.FileContentResponse;
import com.arcadedb.server.ha.message.HACommand;
import com.arcadedb.server.ha.message.InstallDatabaseRequest;
import com.arcadedb.server.ha.message.OkResponse;
import com.arcadedb.server.ha.message.ReplicaConnectFullResyncResponse;
import com.arcadedb.server.ha.message.ReplicaConnectHotResyncResponse;
import com.arcadedb.server.ha.message.ReplicaConnectRequest;
import com.arcadedb.server.ha.message.ReplicaReadyRequest;
import com.arcadedb.server.ha.message.ServerShutdownRequest;
import com.arcadedb.server.ha.message.TxForwardRequest;
import com.arcadedb.server.ha.message.TxForwardResponse;
import com.arcadedb.server.ha.message.TxRequest;
import com.arcadedb.server.ha.message.UpdateClusterConfiguration;
import com.arcadedb.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class HAMessageFactory {
    private final ArcadeDBServer server;
    private final List<Class<? extends HACommand>> commands = new ArrayList<Class<? extends HACommand>>();
    private final Map<Class<? extends HACommand>, Byte> commandMap = new HashMap<Class<? extends HACommand>, Byte>();

    public HAMessageFactory(ArcadeDBServer server) {
        this.server = server;
        this.registerCommand(ReplicaConnectRequest.class);
        this.registerCommand(ReplicaConnectFullResyncResponse.class);
        this.registerCommand(ReplicaConnectHotResyncResponse.class);
        this.registerCommand(DatabaseStructureRequest.class);
        this.registerCommand(DatabaseStructureResponse.class);
        this.registerCommand(DatabaseChangeStructureRequest.class);
        this.registerCommand(DatabaseChangeStructureResponse.class);
        this.registerCommand(FileContentRequest.class);
        this.registerCommand(FileContentResponse.class);
        this.registerCommand(DatabaseAlignRequest.class);
        this.registerCommand(DatabaseAlignResponse.class);
        this.registerCommand(TxRequest.class);
        this.registerCommand(OkResponse.class);
        this.registerCommand(TxForwardRequest.class);
        this.registerCommand(TxForwardResponse.class);
        this.registerCommand(CommandForwardRequest.class);
        this.registerCommand(CommandForwardResponse.class);
        this.registerCommand(ReplicaReadyRequest.class);
        this.registerCommand(UpdateClusterConfiguration.class);
        this.registerCommand(ErrorResponse.class);
        this.registerCommand(ServerShutdownRequest.class);
        this.registerCommand(InstallDatabaseRequest.class);
    }

    public void serializeCommand(HACommand command, Binary buffer, long messageNumber) {
        buffer.clear();
        buffer.putByte(this.getCommandId(command));
        buffer.putLong(messageNumber);
        command.toStream(buffer);
        buffer.flip();
    }

    public Pair<ReplicationMessage, HACommand> deserializeCommand(Binary buffer, byte[] requestBytes) {
        buffer.clear();
        buffer.putByteArray(requestBytes);
        buffer.flip();
        byte commandId = buffer.getByte();
        HACommand request = this.createCommandInstance(commandId);
        if (request != null) {
            long messageNumber = buffer.getLong();
            request.fromStream(this.server, buffer);
            buffer.rewind();
            return new Pair((Object)new ReplicationMessage(messageNumber, buffer), (Object)request);
        }
        LogManager.instance().log((Object)this, Level.SEVERE, "Error on reading request, command %d not valid", (Object)commandId);
        return null;
    }

    private void registerCommand(Class<? extends HACommand> commandClass) {
        this.commands.add(commandClass);
        this.commandMap.put(commandClass, (byte)(this.commands.size() - 1));
    }

    private HACommand createCommandInstance(byte type) {
        if (type > this.commands.size()) {
            throw new IllegalArgumentException("Command with id " + type + " was not found");
        }
        try {
            return this.commands.get(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on creating replication command", (Throwable)e);
            throw new ConfigurationException("Error on creating replication command", e);
        }
    }

    private byte getCommandId(HACommand command) {
        Byte commandId = this.commandMap.get(command.getClass());
        if (commandId == null) {
            throw new IllegalArgumentException("Command of class " + command.getClass() + " was not found");
        }
        return commandId;
    }
}

