/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DatabaseAlignResponse
extends HAAbstractCommand {
    private List<int[]> alignedPages;
    private String remoteServerName;

    public DatabaseAlignResponse() {
    }

    public DatabaseAlignResponse(List<int[]> alignedPages) {
        this.alignedPages = alignedPages;
    }

    public List<int[]> getAlignedPages() {
        return this.alignedPages;
    }

    public String getRemoteServerName() {
        return this.remoteServerName;
    }

    @Override
    public void toStream(Binary stream) {
        if (this.alignedPages == null) {
            stream.putInt(0);
        } else {
            stream.putInt(this.alignedPages.size());
            for (int i = 0; i < this.alignedPages.size(); ++i) {
                int[] page = this.alignedPages.get(i);
                stream.putInt(page[0]);
                stream.putInt(page[1]);
                stream.putInt(page[2]);
            }
        }
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        int total = stream.getInt();
        if (total > 0) {
            this.alignedPages = new ArrayList<int[]>(total);
            for (int i = 0; i < total; ++i) {
                int[] page = new int[]{stream.getInt(), stream.getInt(), stream.getInt()};
                this.alignedPages.add(page);
            }
        } else {
            this.alignedPages = Collections.emptyList();
        }
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        this.remoteServerName = remoteServerName;
        server.receivedResponse(remoteServerName, messageNumber, this);
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int[] array : this.alignedPages) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(Arrays.toString(array));
        }
        return "db-align-response(" + this.remoteServerName + ": [" + buffer + "])";
    }
}

