/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Document;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.RID;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.ImmutableLightEdge;
import com.arcadedb.graph.IterableGraph;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.Vertex;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableEdge;
import com.arcadedb.remote.RemoteMutableEdge;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.EdgeType;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class RemoteVertex {
    public final Vertex vertex;
    public final RemoteDatabase remoteDatabase;

    protected RemoteVertex(Vertex vertex, RemoteDatabase remoteDatabase) {
        this.vertex = vertex;
        this.remoteDatabase = remoteDatabase;
    }

    public long countEdges(Vertex.DIRECTION direction, String edgeType) {
        StringBuilder query = new StringBuilder("select " + direction.toString().toLowerCase(Locale.ENGLISH) + "(");
        if (edgeType != null) {
            query.append("'").append(edgeType).append("'");
        }
        query.append(").size() as count from ").append(this.vertex.getIdentity());
        ResultSet resultSet = this.remoteDatabase.query("sql", query.toString(), new Object[0]);
        return ((Number)resultSet.next().getProperty("count")).longValue();
    }

    public IterableGraph<Edge> getEdges() {
        return this.getEdges(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public IterableGraph<Edge> getEdges(Vertex.DIRECTION direction, String ... edgeTypes) {
        final ResultSet resultSet = this.fetch("E", direction, edgeTypes);
        return new IterableGraph<Edge>(this){

            public Iterator<Edge> iterator() {
                return new Iterator<Edge>(){

                    @Override
                    public boolean hasNext() {
                        return resultSet.hasNext();
                    }

                    @Override
                    public Edge next() {
                        return (Edge)resultSet.next().getEdge().get();
                    }
                };
            }

            public Class<? extends Document> getEntryType() {
                return Edge.class;
            }
        };
    }

    public IterableGraph<Vertex> getVertices() {
        return this.getVertices(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public IterableGraph<Vertex> getVertices(Vertex.DIRECTION direction, String ... edgeTypes) {
        final ResultSet resultSet = this.fetch("", direction, edgeTypes);
        return new IterableGraph<Vertex>(this){

            public Iterator<Vertex> iterator() {
                return new Iterator<Vertex>(){

                    @Override
                    public boolean hasNext() {
                        return resultSet.hasNext();
                    }

                    @Override
                    public Vertex next() {
                        return (Vertex)resultSet.next().getVertex().get();
                    }
                };
            }

            public Class<? extends Document> getEntryType() {
                return Vertex.class;
            }
        };
    }

    public boolean isConnectedTo(Identifiable toVertex) {
        String query = "select from ( select both() as vertices from " + String.valueOf(this.vertex.getIdentity()) + " ) where vertices contains " + String.valueOf(toVertex);
        ResultSet resultSet = this.remoteDatabase.query("sql", query, new Object[0]);
        return resultSet.hasNext();
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction) {
        String query = "select from ( select " + direction.toString().toLowerCase(Locale.ENGLISH) + "() as vertices from " + String.valueOf(this.vertex.getIdentity()) + " ) where vertices contains " + String.valueOf(toVertex);
        ResultSet resultSet = this.remoteDatabase.query("sql", query, new Object[0]);
        return resultSet.hasNext();
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction, String edgeType) {
        String query = "select from ( select " + direction.toString().toLowerCase(Locale.ENGLISH) + "('" + edgeType + "') as vertices from " + String.valueOf(this.vertex.getIdentity()) + " ) where vertices contains " + String.valueOf(toVertex);
        ResultSet resultSet = this.remoteDatabase.query("sql", query, new Object[0]);
        return resultSet.hasNext();
    }

    public RID moveTo(String targetType, String targetBucket) {
        StringBuilder command = new StringBuilder("move vertex ").append(this.vertex.getIdentity()).append(" to");
        if (targetType != null) {
            command.append(" TYPE:`").append(targetType).append("`");
        }
        if (targetBucket != null) {
            command.append(" `").append(targetBucket).append("`");
        }
        ResultSet resultSet = this.remoteDatabase.command("sql", command.toString(), new Object[0]);
        return ((Vertex)resultSet.nextIfAvailable().getVertex().get()).getIdentity();
    }

    @Deprecated
    public MutableEdge newEdge(String edgeType, Identifiable toVertex, boolean bidirectional, Object ... properties) {
        if (!bidirectional && ((EdgeType)this.remoteDatabase.getSchema().getType(edgeType)).isBidirectional()) {
            throw new IllegalArgumentException("Edge type '" + edgeType + "' is not bidirectional");
        }
        return this.newEdge(edgeType, toVertex, properties);
    }

    public MutableEdge newEdge(String edgeType, Identifiable toVertex, Object ... properties) {
        String bucketName;
        if (edgeType.startsWith("bucket:")) {
            bucketName = edgeType.substring("bucket:".length());
            DocumentType type = this.remoteDatabase.getSchema().getTypeByBucketName(bucketName);
            edgeType = type == null ? null : type.getName();
        } else {
            bucketName = null;
        }
        StringBuilder query = new StringBuilder("create edge" + (String)(edgeType != null ? " `" + edgeType + "`" : ""));
        if (bucketName != null) {
            query.append(" bucket `");
            query.append(bucketName);
            query.append("`");
        }
        query.append(" from " + String.valueOf(this.vertex.getIdentity()) + " to " + String.valueOf(toVertex.getIdentity()));
        if (properties != null && properties.length > 0) {
            query.append(" set ");
            if (properties.length == 1 && properties[0] instanceof Map) {
                Map map = (Map)properties[0];
                properties = new Object[map.size() * 2];
                int i = 0;
                for (Map.Entry entry : map.entrySet()) {
                    properties[i++] = entry.getKey();
                    properties[i++] = entry.getValue();
                }
            } else if (properties.length % 2 != 0) {
                throw new IllegalArgumentException("Properties must be an even number as pairs of name, value");
            }
            for (int i = 0; i < properties.length; i += 2) {
                String propName = (String)properties[i];
                Object propValue = properties[i + 1];
                if (i > 0) {
                    query.append(", ");
                }
                query.append("`");
                query.append(propName);
                query.append("` = ");
                if (propValue instanceof String) {
                    query.append("'");
                }
                query.append(propValue);
                if (!(propValue instanceof String)) continue;
                query.append("'");
            }
        }
        ResultSet resultSet = this.remoteDatabase.command("sql", query.toString(), new Object[0]);
        return new RemoteMutableEdge((RemoteImmutableEdge)((Object)resultSet.next().getEdge().get()));
    }

    public ImmutableLightEdge newLightEdge(String edgeType, Identifiable toVertex) {
        throw new UnsupportedOperationException("Creating light edges is not supported from remote database");
    }

    @Deprecated
    public ImmutableLightEdge newLightEdge(String edgeType, Identifiable toVertex, boolean bidirectional) {
        throw new UnsupportedOperationException("Creating light edges is not supported from remote database");
    }

    public void delete() {
        this.remoteDatabase.command("sql", "delete from " + String.valueOf(this.vertex.getIdentity()), new Object[0]);
    }

    private ResultSet fetch(String suffix, Vertex.DIRECTION direction, String[] types) {
        StringBuilder query = new StringBuilder("select expand( " + direction.toString().toLowerCase(Locale.ENGLISH) + suffix + "(");
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                query.append(",");
            }
            query.append("'" + types[i] + "'");
        }
        query.append(") ) from " + String.valueOf(this.vertex.getIdentity()));
        return this.remoteDatabase.query("sql", query.toString(), new Object[0]);
    }
}

