/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.remote.RemoteException;
import com.arcadedb.remote.RemoteHttpComponent;
import com.arcadedb.serializer.json.JSONObject;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteServer
extends RemoteHttpComponent {
    public RemoteServer(String server, int port, String userName, String userPassword) {
        this(server, port, userName, userPassword, new ContextConfiguration());
    }

    public RemoteServer(String server, int port, String userName, String userPassword, ContextConfiguration configuration) {
        super(server, port, userName, userPassword, configuration);
    }

    public void create(String databaseName) {
        this.serverCommand("POST", "create database " + databaseName, true, true, null);
    }

    public List<String> databases() {
        return (List)this.serverCommand("POST", "list databases", true, true, (connection, response) -> response.getJSONArray("result").toList());
    }

    public boolean exists(String databaseName) {
        return (Boolean)this.httpCommand("GET", databaseName, "exists", "SQL", null, null, false, true, (connection, response) -> response.getBoolean("result"));
    }

    public void drop(String databaseName) {
        try {
            JSONObject jsonRequest = new JSONObject().put("command", "drop database " + databaseName);
            String payload = this.getRequestPayload(jsonRequest);
            HttpRequest request = this.createRequestBuilder("POST", this.getUrl("server")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("Content-Type", "application/json").build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                Exception detail = this.manageException(response, "drop database");
                throw new RemoteException("Error on deleting database", detail);
            }
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on deleting database", (Throwable)e);
        }
    }

    public String toString() {
        return this.protocol + "://" + this.currentServer + ":" + this.currentPort;
    }

    public void createUser(String userName, String password, Map<String, String> databases) {
        try {
            JSONObject jsonUser = new JSONObject();
            jsonUser.put("name", userName);
            jsonUser.put("password", password);
            if (databases != null && !databases.isEmpty()) {
                JSONObject databasesJson = new JSONObject();
                for (Map.Entry<String, String> entry : databases.entrySet()) {
                    databasesJson.put(entry.getKey(), (Object)new String[]{entry.getValue()});
                }
                jsonUser.put("databases", (Object)databasesJson);
            }
            JSONObject jsonRequest = new JSONObject().put("command", "create user " + String.valueOf(jsonUser));
            String payload = this.getRequestPayload(jsonRequest);
            HttpRequest request = this.createRequestBuilder("POST", this.getUrl("server")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("Content-Type", "application/json").build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                Exception detail = this.manageException(response, "create user");
                throw new SecurityException("Error on creating user", detail);
            }
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on creating user", (Throwable)e);
        }
    }

    public void createUser(String userName, String password, List<String> databases) {
        HashMap<String, String> databasesWithGroups = new HashMap<String, String>();
        for (String dbName : databases) {
            databasesWithGroups.put(dbName, "admin");
        }
        this.createUser(userName, password, databasesWithGroups);
    }

    public void dropUser(String userName) {
        try {
            JSONObject jsonRequest = new JSONObject().put("command", "drop user " + userName);
            String payload = this.getRequestPayload(jsonRequest);
            HttpRequest request = this.createRequestBuilder("POST", this.getUrl("server")).POST(HttpRequest.BodyPublishers.ofString(payload)).header("Content-Type", "application/json").build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                Exception detail = this.manageException(response, "drop user");
                throw new RemoteException("Error on deleting user", detail);
            }
        }
        catch (Exception e) {
            throw new RemoteException("Error on deleting user", e);
        }
    }

    private Object serverCommand(String method, String command, boolean leaderIsPreferable, boolean autoReconnect, RemoteHttpComponent.Callback callback) {
        return this.httpCommand(method, null, "server", null, command, null, leaderIsPreferable, autoReconnect, callback);
    }
}

