/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.Document;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.Record;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.serializer.json.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class RemoteMutableDocument
extends MutableDocument {
    protected final RemoteDatabase remoteDatabase;

    protected RemoteMutableDocument(RemoteDatabase database, String typeName) {
        super(null, database.getSchema().getType(typeName), null);
        this.remoteDatabase = database;
    }

    protected RemoteMutableDocument(RemoteImmutableDocument source) {
        super(null, source.getType(), source.getIdentity());
        this.remoteDatabase = source.remoteDatabase;
        this.map.putAll(source.map);
    }

    public MutableDocument save() {
        this.rid = this.remoteDatabase.saveRecord(this);
        this.dirty = false;
        return this;
    }

    public MutableDocument save(String bucketName) {
        this.rid = this.remoteDatabase.saveRecord(this, bucketName);
        this.dirty = false;
        return this;
    }

    public void delete() {
        this.remoteDatabase.deleteRecord((Record)this);
    }

    public void reload() {
        ResultSet resultSet = this.remoteDatabase.query("sql", "select from " + String.valueOf(this.rid), new Object[0]);
        if (!resultSet.hasNext()) {
            throw new RecordNotFoundException("Record " + String.valueOf(this.rid) + " not found", this.rid);
        }
        Document document = resultSet.next().toElement();
        this.map.clear();
        this.map.putAll(document.propertiesAsMap());
        this.dirty = false;
    }

    public JSONObject toJSON(boolean includeMetadata) {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map, this.type, includeMetadata, new String[0]);
        if (includeMetadata) {
            result.put("@cat", "d");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public Map<String, Object> toMap(boolean includeMetadata) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        if (includeMetadata) {
            result.put("@cat", "d");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public DocumentType getType() {
        throw new UnsupportedOperationException("Schema API are not supported in remote database");
    }

    public Database getDatabase() {
        throw new UnsupportedOperationException("Embedded Database API not supported in remote database");
    }

    public Binary getBuffer() {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    public void setBuffer(Binary buffer) {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    protected void checkForLazyLoadingProperties() {
    }

    protected Object convertValueToSchemaType(String name, Object value, DocumentType type) {
        return value;
    }
}

