/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Database;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.RID;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.ImmutableLightEdge;
import com.arcadedb.graph.IterableGraph;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.Vertex;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.remote.RemoteMutableVertex;
import com.arcadedb.remote.RemoteVertex;
import com.arcadedb.schema.EdgeType;
import com.arcadedb.serializer.json.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class RemoteImmutableVertex
extends RemoteImmutableDocument
implements Vertex {
    private final RemoteVertex internal;

    protected RemoteImmutableVertex(RemoteDatabase database, Map<String, Object> properties) {
        super(database, properties);
        this.internal = new RemoteVertex(this, database);
    }

    public RemoteMutableVertex modify() {
        return new RemoteMutableVertex(this);
    }

    public RemoteDatabase getRemoteDatabase() {
        return this.internal.remoteDatabase;
    }

    public void delete() {
        this.internal.delete();
    }

    public long countEdges(Vertex.DIRECTION direction, String edgeType) {
        return this.internal.countEdges(direction, edgeType);
    }

    public IterableGraph<Edge> getEdges() {
        return this.internal.getEdges(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public IterableGraph<Edge> getEdges(Vertex.DIRECTION direction, String ... edgeTypes) {
        return this.internal.getEdges(direction, edgeTypes);
    }

    public IterableGraph<Vertex> getVertices() {
        return this.internal.getVertices(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public IterableGraph<Vertex> getVertices(Vertex.DIRECTION direction, String ... edgeTypes) {
        return this.internal.getVertices(direction, edgeTypes);
    }

    public boolean isConnectedTo(Identifiable toVertex) {
        return this.internal.isConnectedTo(toVertex);
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction) {
        return this.internal.isConnectedTo(toVertex, direction);
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction, String edgeType) {
        return this.internal.isConnectedTo(toVertex, direction, edgeType);
    }

    public RID moveToType(String targetType) {
        return this.internal.vertex.moveToType(targetType);
    }

    public RID moveToBucket(String targetBucket) {
        return this.internal.vertex.moveToBucket(targetBucket);
    }

    public MutableEdge newEdge(String edgeType, Identifiable toVertex, Object ... properties) {
        return this.internal.newEdge(edgeType, toVertex, properties);
    }

    @Deprecated
    public MutableEdge newEdge(String edgeType, Identifiable toVertex, boolean bidirectional, Object ... properties) {
        if (!bidirectional && ((EdgeType)this.database.getSchema().getType(edgeType)).isBidirectional()) {
            throw new IllegalArgumentException("Edge type '" + edgeType + "' is not bidirectional");
        }
        return this.internal.newEdge(edgeType, toVertex, properties);
    }

    public ImmutableLightEdge newLightEdge(String edgeType, Identifiable toVertex) {
        return this.internal.newLightEdge(edgeType, toVertex);
    }

    @Deprecated
    public ImmutableLightEdge newLightEdge(String edgeType, Identifiable toVertex, boolean bidirectional) {
        if (!bidirectional && ((EdgeType)this.database.getSchema().getType(edgeType)).isBidirectional()) {
            throw new IllegalArgumentException("Edge type '" + edgeType + "' is not bidirectional");
        }
        return this.internal.newLightEdge(edgeType, toVertex);
    }

    public Vertex asVertex() {
        return this;
    }

    public Vertex asVertex(boolean loadContent) {
        if (loadContent) {
            this.checkForLazyLoading();
        }
        return this;
    }

    public Map<String, Object> propertiesAsMap() {
        return new HashMap<String, Object>(this.map);
    }

    @Override
    public Map<String, Object> toMap(boolean includeMetadata) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        if (includeMetadata) {
            result.put("@cat", "v");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    @Override
    public JSONObject toJSON(boolean includeMetadata) {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map, this.type, includeMetadata, new String[0]);
        if (includeMetadata) {
            result.put("@cat", "v");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }
}

