/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Database;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.RID;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.Vertex;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.remote.RemoteMutableEdge;
import com.arcadedb.serializer.json.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class RemoteImmutableEdge
extends RemoteImmutableDocument
implements Edge {
    private final RID out;
    private final RID in;

    public RemoteImmutableEdge(RemoteDatabase database, Map<String, Object> properties) {
        super(database, properties);
        this.out = new RID((BasicDatabase)this.remoteDatabase, (String)properties.get("@out"));
        this.in = new RID((BasicDatabase)this.remoteDatabase, (String)properties.get("@in"));
    }

    public RID getOut() {
        return this.out;
    }

    public Vertex getOutVertex() {
        return this.loadVertex(this.out);
    }

    public RID getIn() {
        return this.in;
    }

    public Vertex getInVertex() {
        return this.loadVertex(this.in);
    }

    public Vertex getVertex(Vertex.DIRECTION iDirection) {
        if (iDirection == Vertex.DIRECTION.OUT) {
            return this.getOutVertex();
        }
        return this.getInVertex();
    }

    public MutableEdge modify() {
        return new RemoteMutableEdge(this);
    }

    public void delete() {
        this.remoteDatabase.command("sql", "delete from " + String.valueOf(this.rid), new Object[0]);
    }

    private Vertex loadVertex(RID rid) {
        ResultSet result = this.remoteDatabase.query("sql", "select from " + String.valueOf(rid), new Object[0]);
        if (result.hasNext()) {
            return (Vertex)result.next().getVertex().get();
        }
        return null;
    }

    public Edge asEdge() {
        return this;
    }

    public Edge asEdge(boolean loadContent) {
        if (loadContent) {
            this.checkForLazyLoading();
        }
        return this;
    }

    @Override
    public Map<String, Object> toMap(boolean includeMetadata) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        if (includeMetadata) {
            result.put("@cat", "e");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    @Override
    public JSONObject toJSON(boolean includeMetadata) {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map, this.type, includeMetadata, new String[0]);
        if (includeMetadata) {
            result.put("@cat", "e");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }
}

