/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.network.binary;

import com.arcadedb.log.LogManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public abstract class Channel {
    private static final AtomicLong metricGlobalTransmittedBytes = new AtomicLong();
    private static final AtomicLong metricGlobalReceivedBytes = new AtomicLong();
    private static final AtomicLong metricGlobalFlushes = new AtomicLong();
    public volatile Socket socket;
    public InputStream inStream;
    public OutputStream outStream;
    private final AtomicLong metricTransmittedBytes = new AtomicLong();
    private final AtomicLong metricReceivedBytes = new AtomicLong();
    private final AtomicLong metricFlushes = new AtomicLong();

    public Channel(Socket iSocket) throws IOException {
        this.socket = iSocket;
        this.socket.setTcpNoDelay(true);
    }

    public static String getLocalIpAddress(boolean iFavoriteIp4) throws SocketException {
        String bestAddress = null;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress current_addr = addresses.nextElement();
                if (current_addr.isLoopbackAddress() || bestAddress != null && (!iFavoriteIp4 || !(current_addr instanceof Inet4Address))) continue;
                bestAddress = current_addr.getHostAddress();
            }
        }
        return bestAddress;
    }

    public boolean inputHasData() {
        if (this.inStream != null) {
            try {
                return this.inStream.available() > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void flush() throws IOException {
        if (this.outStream != null) {
            this.outStream.flush();
        }
    }

    public synchronized void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.FINE, "Error during socket close", (Throwable)e);
        }
        try {
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.FINE, "Error during closing of input stream", (Throwable)e);
        }
        try {
            if (this.outStream != null) {
                this.outStream.close();
                this.outStream = null;
            }
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.FINE, "Error during closing of output stream", (Throwable)e);
        }
    }

    public String toString() {
        return this.socket != null ? this.socket.getRemoteSocketAddress().toString() + "@" + this.hashCode() : "Not connected";
    }

    public String getLocalSocketAddress() {
        return this.socket != null ? this.socket.getLocalSocketAddress().toString() : "?";
    }

    protected void updateMetricTransmittedBytes(int iDelta) {
        metricGlobalTransmittedBytes.addAndGet(iDelta);
        this.metricTransmittedBytes.addAndGet(iDelta);
    }

    protected void updateMetricReceivedBytes(int iDelta) {
        metricGlobalReceivedBytes.addAndGet(iDelta);
        this.metricReceivedBytes.addAndGet(iDelta);
    }

    protected void updateMetricFlushes() {
        metricGlobalFlushes.incrementAndGet();
        this.metricFlushes.incrementAndGet();
    }
}

