/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.engine.Bucket;
import com.arcadedb.engine.Component;
import com.arcadedb.engine.Dictionary;
import com.arcadedb.engine.LocalBucket;
import com.arcadedb.exception.SchemaException;
import com.arcadedb.function.FunctionDefinition;
import com.arcadedb.function.FunctionLibraryDefinition;
import com.arcadedb.index.Index;
import com.arcadedb.index.TypeIndex;
import com.arcadedb.index.lsm.LSMTreeIndexAbstract;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteBucket;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteDocumentType;
import com.arcadedb.remote.RemoteEdgeType;
import com.arcadedb.remote.RemoteVertexType;
import com.arcadedb.schema.BucketIndexBuilder;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.EdgeType;
import com.arcadedb.schema.LocalSchema;
import com.arcadedb.schema.ManualIndexBuilder;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.Type;
import com.arcadedb.schema.TypeBuilder;
import com.arcadedb.schema.TypeIndexBuilder;
import com.arcadedb.schema.VectorIndexBuilder;
import com.arcadedb.schema.VertexType;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class RemoteSchema
implements Schema {
    private final RemoteDatabase remoteDatabase;
    private Map<String, RemoteDocumentType> types = null;
    private Map<String, RemoteBucket> buckets = null;

    public RemoteSchema(RemoteDatabase remoteDatabase) {
        this.remoteDatabase = remoteDatabase;
    }

    public boolean existsType(String typeName) {
        this.checkSchemaIsLoaded();
        return this.types.containsKey(typeName);
    }

    public boolean existsBucket(String bucketName) {
        return this.remoteDatabase.command("sql", "select from schema:types where '" + bucketName + "' IN buckets", new Object[0]).hasNext();
    }

    public boolean existsIndex(String indexName) {
        return this.remoteDatabase.command("sql", "select from schema:indexes where name = `" + indexName + "`", new Object[0]).hasNext();
    }

    public void dropBucket(String bucketName) {
        this.remoteDatabase.command("sql", "drop bucket `" + bucketName + "`", new Object[0]);
    }

    public void dropType(String typeName) {
        this.remoteDatabase.command("sql", "drop type `" + typeName + "`", new Object[0]);
        this.invalidateSchema();
    }

    public void dropIndex(String indexName) {
        this.remoteDatabase.command("sql", "drop index `" + indexName + "`", new Object[0]);
    }

    public LocalBucket createBucket(String bucketName) {
        ResultSet result = this.remoteDatabase.command("sql", "create bucket `" + bucketName + "`", new Object[0]);
        return null;
    }

    public TypeIndex createTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String ... propertyNames) {
        String propList = Arrays.stream(propertyNames).collect(Collectors.joining(","));
        this.remoteDatabase.command("sql", "create index on `" + typeName + "`(" + propList + ") " + (unique ? "UNIQUE" : "NOTUNIQUE") + " ENGINE " + indexType.name(), new Object[0]);
        return null;
    }

    public TypeIndex getOrCreateTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String ... propertyNames) {
        String propList = Arrays.stream(propertyNames).collect(Collectors.joining(","));
        this.remoteDatabase.command("sql", "create index if not exists on `" + typeName + "`(" + propList + ") " + (unique ? "UNIQUE" : "NOTUNIQUE") + " ENGINE " + indexType.name(), new Object[0]);
        return null;
    }

    public DocumentType createDocumentType(String typeName) {
        ResultSet result = this.remoteDatabase.command("sql", "create document type `" + typeName + "`", new Object[0]);
        if (result.hasNext()) {
            return this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating document type '" + typeName + "'");
    }

    public DocumentType createDocumentType(String typeName, int buckets) {
        ResultSet result = this.remoteDatabase.command("sql", "create document type `" + typeName + "` buckets " + buckets, new Object[0]);
        if (result.hasNext()) {
            return this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating document type '" + typeName + "'");
    }

    public DocumentType getOrCreateDocumentType(String typeName) {
        ResultSet result = this.remoteDatabase.command("sql", "create document type `" + typeName + "` if not exists", new Object[0]);
        if (result.hasNext()) {
            return this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating document type '" + typeName + "'");
    }

    public DocumentType getOrCreateDocumentType(String typeName, int buckets) {
        ResultSet result = this.remoteDatabase.command("sql", "create document type `" + typeName + "` if not exists buckets " + buckets, new Object[0]);
        if (result.hasNext()) {
            return this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating document type '" + typeName + "'");
    }

    public VertexType createVertexType(String typeName) {
        ResultSet result = this.remoteDatabase.command("sql", "create vertex type `" + typeName + "`", new Object[0]);
        if (result.hasNext()) {
            return (VertexType)this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating vertex type '" + typeName + "'");
    }

    public VertexType getOrCreateVertexType(String typeName, int buckets) {
        ResultSet result = this.remoteDatabase.command("sql", "create vertex type `" + typeName + "` if not exists buckets " + buckets, new Object[0]);
        if (result.hasNext()) {
            return (VertexType)this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating vertex type '" + typeName + "'");
    }

    public VertexType getOrCreateVertexType(String typeName) {
        ResultSet result = this.remoteDatabase.command("sql", "create vertex type `" + typeName + "` if not exists", new Object[0]);
        if (result.hasNext()) {
            return (VertexType)this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating vertex type '" + typeName + "'");
    }

    public VertexType createVertexType(String typeName, int buckets) {
        ResultSet result = this.remoteDatabase.command("sql", "create vertex type `" + typeName + "` buckets " + buckets, new Object[0]);
        if (result.hasNext()) {
            return (VertexType)this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating vertex type '" + typeName + "'");
    }

    public EdgeType createEdgeType(String typeName) {
        ResultSet result = this.remoteDatabase.command("sql", "create edge type `" + typeName + "`", new Object[0]);
        if (result.hasNext()) {
            return (EdgeType)this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating edge type '" + typeName + "'");
    }

    public EdgeType getOrCreateEdgeType(String typeName) {
        ResultSet result = this.remoteDatabase.command("sql", "create edge type `" + typeName + "` if not exists", new Object[0]);
        if (result.hasNext()) {
            return (EdgeType)this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating edge type '" + typeName + "'");
    }

    public EdgeType createEdgeType(String typeName, int buckets) {
        ResultSet result = this.remoteDatabase.command("sql", "create edge type `" + typeName + "` buckets " + buckets, new Object[0]);
        if (result.hasNext()) {
            return (EdgeType)this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating edge type '" + typeName + "'");
    }

    public EdgeType getOrCreateEdgeType(String typeName, int buckets) {
        ResultSet result = this.remoteDatabase.command("sql", "create edge type `" + typeName + "` if not exists buckets " + buckets, new Object[0]);
        if (result.hasNext()) {
            return (EdgeType)this.reload().getType(typeName);
        }
        throw new SchemaException("Error on creating edge type '" + typeName + "'");
    }

    public Collection<? extends DocumentType> getTypes() {
        this.checkSchemaIsLoaded();
        return this.types.values();
    }

    public DocumentType getType(String typeName) {
        this.checkSchemaIsLoaded();
        return this.types.get(typeName);
    }

    public LocalSchema getEmbedded() {
        return null;
    }

    @Deprecated
    public TypeIndexBuilder buildTypeIndex(String typeName, String[] propertyNames) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public BucketIndexBuilder buildBucketIndex(String typeName, String bucketName, String[] propertyNames) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ManualIndexBuilder buildManualIndex(String indexName, Type[] keyTypes) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public VectorIndexBuilder buildVectorIndex() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeBuilder<DocumentType> buildDocumentType() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeBuilder<VertexType> buildVertexType() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeBuilder<EdgeType> buildEdgeType() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DocumentType createDocumentType(String typeName, List<Bucket> buckets) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DocumentType createDocumentType(String typeName, int buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DocumentType createDocumentType(String typeName, List<Bucket> buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DocumentType getOrCreateDocumentType(String typeName, int buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public EdgeType createEdgeType(String typeName, List<Bucket> buckets) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public VertexType createVertexType(String typeName, List<Bucket> buckets) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public VertexType createVertexType(String typeName, int buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public VertexType createVertexType(String typeName, List<Bucket> buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public VertexType getOrCreateVertexType(String typeName, int buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public EdgeType createEdgeType(String typeName, int buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public EdgeType createEdgeType(String typeName, List<Bucket> buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public EdgeType getOrCreateEdgeType(String typeName, int buckets, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TimeZone getTimeZone() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setTimeZone(TimeZone timeZone) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public ZoneId getZoneId() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setZoneId(ZoneId zoneId) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getDateFormat() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setDateFormat(String dateFormat) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getDateTimeFormat() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setDateTimeFormat(String dateTimeFormat) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getEncoding() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setEncoding(String encoding) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Schema registerFunctionLibrary(FunctionLibraryDefinition library) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Schema unregisterFunctionLibrary(String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Iterable<FunctionLibraryDefinition> getFunctionLibraries() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean hasFunctionLibrary(String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public FunctionLibraryDefinition getFunctionLibrary(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public FunctionDefinition getFunction(String libraryName, String functionName) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Component getFileById(int id) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public RemoteBucket getBucketByName(String name) {
        RemoteBucket b = this.buckets.get(name);
        if (b == null) {
            throw new SchemaException("Bucket '" + name + "' not found");
        }
        return b;
    }

    @Deprecated
    public Component getFileByIdIfExists(int id) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Collection<? extends Bucket> getBuckets() {
        return this.buckets.values();
    }

    @Deprecated
    public LocalBucket getBucketById(int id) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DocumentType copyType(String typeName, String newTypeName, Class<? extends DocumentType> newType, int buckets, int pageSize, int transactionBatchSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Index[] getIndexes() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Index getIndexByName(String indexName) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeIndex createTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String[] propertyNames, int pageSize) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeIndex createTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String[] propertyNames, int pageSize, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeIndex createTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String[] propertyNames, int pageSize, LSMTreeIndexAbstract.NULL_STRATEGY nullStrategy, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeIndex getOrCreateTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String[] propertyNames, int pageSize, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeIndex getOrCreateTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String[] propertyNames, int pageSize, LSMTreeIndexAbstract.NULL_STRATEGY nullStrategy, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Index createBucketIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String bucketName, String[] propertyNames, int pageSize, LSMTreeIndexAbstract.NULL_STRATEGY nullStrategy, Index.BuildIndexCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Index createManualIndex(Schema.INDEX_TYPE indexType, boolean unique, String indexName, Type[] keyTypes, int pageSize, LSMTreeIndexAbstract.NULL_STRATEGY nullStrategy) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getTypeNameByBucketId(int bucketId) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DocumentType getTypeByBucketId(int bucketId) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DocumentType getInvolvedTypeByBucketId(int bucketId) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public DocumentType getTypeByBucketName(String bucketName) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Dictionary getDictionary() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public TypeIndex getOrCreateTypeIndex(Schema.INDEX_TYPE indexType, boolean unique, String typeName, String[] propertyNames, int pageSize) {
        throw new UnsupportedOperationException();
    }

    void invalidateSchema() {
        this.types = null;
    }

    public RemoteSchema reload() {
        ResultSet result = this.remoteDatabase.command("sql", "select from schema:types", new Object[0]);
        ArrayList<Result> cached = new ArrayList<Result>();
        while (result.hasNext()) {
            cached.add(result.next());
        }
        if (this.types == null) {
            this.types = new HashMap<String, RemoteDocumentType>();
            this.buckets = new HashMap<String, RemoteBucket>();
        } else {
            this.buckets.clear();
        }
        for (Result record : cached) {
            List typeBucketNames = (List)record.getProperty("buckets");
            for (String typeBucketName : typeBucketNames) {
                this.buckets.computeIfAbsent(typeBucketName, name -> new RemoteBucket((String)name));
            }
        }
        for (Result record : cached) {
            String typeName = (String)record.getProperty("name");
            RemoteDocumentType type = this.types.get(typeName);
            if (type == null) {
                switch ((String)record.getProperty("type")) {
                    case "document": {
                        type = new RemoteDocumentType(this.remoteDatabase, record);
                        break;
                    }
                    case "vertex": {
                        type = new RemoteVertexType(this.remoteDatabase, record);
                        break;
                    }
                    case "edge": {
                        type = new RemoteEdgeType(this.remoteDatabase, record, record.hasProperty("bidirectional") ? (Boolean)record.getProperty("bidirectional") : true);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown record type for " + typeName);
                    }
                }
                this.types.put(typeName, type);
                continue;
            }
            type.reload(record);
        }
        return this;
    }

    private void checkSchemaIsLoaded() {
        if (this.types == null) {
            this.reload();
        }
    }
}

