/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseStats;
import com.arcadedb.database.RID;
import com.arcadedb.exception.ConcurrentModificationException;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.exception.DuplicatedKeyException;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.exception.SchemaException;
import com.arcadedb.exception.TimeoutException;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.HostUtil;
import com.arcadedb.network.binary.QuorumNotReachedException;
import com.arcadedb.network.binary.ServerIsNotTheLeaderException;
import com.arcadedb.remote.RemoteException;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.utility.FileUtils;
import com.arcadedb.utility.Pair;
import com.arcadedb.utility.RWLockContext;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class RemoteHttpComponent
extends RWLockContext {
    public static final int DEFAULT_PORT = 2480;
    private final String originalServer;
    private final int originalPort;
    private int apiVersion = 1;
    protected final ContextConfiguration configuration;
    private final String userName;
    private final String userPassword;
    private final List<Pair<String, Integer>> replicaServerList = new ArrayList<Pair<String, Integer>>();
    protected String currentServer;
    protected int currentPort;
    private CONNECTION_STRATEGY connectionStrategy = CONNECTION_STRATEGY.ROUND_ROBIN;
    private Pair<String, Integer> leaderServer;
    private int currentReplicaServerIndex = -1;
    private int timeout;
    protected static final String protocol = "http";
    private static final String charset = "UTF-8";
    protected final DatabaseStats stats = new DatabaseStats();

    public RemoteHttpComponent(String server, int port, String userName, String userPassword) {
        this(server, port, userName, userPassword, new ContextConfiguration());
    }

    public RemoteHttpComponent(String server, int port, String userName, String userPassword, ContextConfiguration configuration) {
        this.originalServer = server;
        this.originalPort = port;
        this.currentServer = this.originalServer;
        this.currentPort = this.originalPort;
        this.userName = userName;
        this.userPassword = userPassword;
        this.configuration = configuration;
        this.timeout = this.configuration.getValueAsInteger(GlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
        this.requestClusterConfiguration();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    List<Pair<String, Integer>> getReplicaServerList() {
        return this.replicaServerList;
    }

    public Map<String, Object> getStats() {
        return this.stats.toMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object httpCommand(String method, String extendedURL, String operation, String language, String payloadCommand, Map<String, Object> params, boolean leaderIsPreferable, boolean autoReconnect, Callback callback) {
        Object lastException = null;
        int maxRetry = leaderIsPreferable ? 3 : this.getReplicaServerList().size() + 1;
        Pair<String, Integer> connectToServer = leaderIsPreferable && this.leaderServer != null ? this.leaderServer : new Pair<String, Integer>((Object)this.currentServer, (Object)this.currentPort);
        String server = null;
        for (int retry = 0; retry < maxRetry && connectToServer != null; ++retry) {
            server = (String)connectToServer.getFirst() + ":" + String.valueOf(connectToServer.getSecond());
            String url = "http://" + server + "/api/v" + this.apiVersion + "/" + operation;
            if (extendedURL != null) {
                url = url + "/" + extendedURL;
            }
            try {
                HttpURLConnection connection = this.createConnection(method, url);
                connection.setDoOutput(true);
                try {
                    if (payloadCommand != null) {
                        if ("GET".equalsIgnoreCase(method)) {
                            throw new IllegalArgumentException("Cannot execute a HTTP GET request with a payload");
                        }
                        JSONObject jsonRequest = new JSONObject();
                        if (language != null) {
                            jsonRequest.put("language", language);
                        }
                        jsonRequest.put("command", payloadCommand);
                        jsonRequest.put("serializer", "record");
                        if (params != null) {
                            jsonRequest.put("params", (Object)new JSONObject(params));
                        }
                        this.setRequestPayload(connection, jsonRequest);
                    }
                    connection.connect();
                    if (connection.getResponseCode() != 200) {
                        lastException = this.manageException(connection, payloadCommand != null ? payloadCommand : operation);
                        if (lastException instanceof RuntimeException && ((Throwable)lastException).getMessage().equals("Empty payload received")) {
                            LogManager.instance().log((Object)this, Level.FINE, "Empty payload received, retrying (retry=%d/%d)...", null, (Object)retry, (Object)maxRetry);
                        }
                        continue;
                    }
                    JSONObject response = new JSONObject(FileUtils.readStreamAsString((InputStream)connection.getInputStream(), (String)charset));
                    if (callback == null) {
                        Object var18_22 = null;
                        return var18_22;
                    }
                    Object object = callback.call(connection, response);
                    return object;
                }
                finally {
                    connection.disconnect();
                }
            }
            catch (ServerIsNotTheLeaderException | IOException e) {
                lastException = e;
                if (!autoReconnect) break;
                if (!this.reloadClusterConfiguration()) {
                    throw new RemoteException("Error on executing remote operation " + operation + ", no server available", (Throwable)e);
                }
                Pair<String, Integer> currentConnectToServer = connectToServer;
                connectToServer = leaderIsPreferable && !currentConnectToServer.equals(this.leaderServer) ? this.leaderServer : this.getNextReplicaAddress();
                if (connectToServer == null) continue;
                LogManager.instance().log((Object)this, Level.WARNING, "Remote server (%s:%d) seems unreachable, switching to server %s:%d...", null, currentConnectToServer.getFirst(), currentConnectToServer.getSecond(), connectToServer.getFirst(), connectToServer.getSecond());
                continue;
            }
            catch (DuplicatedKeyException | NeedRetryException | TimeoutException | TransactionException | RemoteException | SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RemoteException("Error on executing remote operation " + operation + " (cause: " + e.getMessage() + ")", e);
            }
        }
        if (!(lastException instanceof RuntimeException)) throw new RemoteException("Error on executing remote operation '" + operation + "' (server=" + server + " retry=" + maxRetry + ")", (Throwable)lastException);
        RuntimeException exception = (RuntimeException)lastException;
        throw exception;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getLeaderAddress() {
        return (String)this.leaderServer.getFirst() + ":" + String.valueOf(this.leaderServer.getSecond());
    }

    public List<String> getReplicaAddresses() {
        return this.replicaServerList.stream().map(e -> (String)e.getFirst() + ":" + String.valueOf(e.getSecond())).collect(Collectors.toList());
    }

    HttpURLConnection createConnection(String httpMethod, String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestMethod(httpMethod);
        String authorization = this.userName + ":" + this.userPassword;
        connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(authorization.getBytes(DatabaseFactory.getDefaultCharset())));
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        return connection;
    }

    void requestClusterConfiguration() {
        JSONObject response;
        try {
            HttpURLConnection connection = this.createConnection("GET", this.getUrl("server?mode=cluster"));
            connection.connect();
            if (connection.getResponseCode() != 200) {
                Exception detail = this.manageException(connection, "cluster configuration");
                if (detail instanceof SecurityException) {
                    throw detail;
                }
                throw new RemoteException("Error on requesting cluster configuration: " + connection.getResponseMessage(), detail);
            }
            response = new JSONObject(FileUtils.readStreamAsString((InputStream)connection.getInputStream(), (String)charset));
            LogManager.instance().log((Object)this, Level.FINE, "Configuring remote database: %s", null, (Object)response);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on connecting to the server", (Throwable)e);
        }
        try {
            if (!response.has("ha")) {
                this.leaderServer = new Pair((Object)this.originalServer, (Object)this.originalPort);
                this.replicaServerList.clear();
                return;
            }
            JSONObject ha = response.getJSONObject("ha");
            String cfgLeaderServer = (String)ha.get("leaderAddress");
            String[] leaderServerParts = HostUtil.parseHostAddress(cfgLeaderServer, "2424");
            this.leaderServer = new Pair((Object)leaderServerParts[0], (Object)Integer.parseInt(leaderServerParts[1]));
            String cfgReplicaServers = (String)ha.get("replicaAddresses");
            this.replicaServerList.clear();
            if (cfgReplicaServers != null && !cfgReplicaServers.isEmpty()) {
                String[] serverEntries;
                for (String serverEntry : serverEntries = cfgReplicaServers.split(",")) {
                    try {
                        String[] serverParts = HostUtil.parseHostAddress(serverEntry, "2480");
                        String sHost = serverParts[0];
                        int sPort = Integer.parseInt(serverParts[1]);
                        this.replicaServerList.add((Pair<String, Integer>)new Pair((Object)sHost, (Object)sPort));
                    }
                    catch (Exception e) {
                        LogManager.instance().log((Object)this, Level.SEVERE, "Invalid replica server address '%s'", null, (Object)serverEntry);
                    }
                }
            }
            LogManager.instance().log((Object)this, Level.FINE, "Remote Database configured with leader=%s and replicas=%s", null, this.leaderServer, this.replicaServerList);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on requesting cluster configuration", (Throwable)e);
        }
    }

    private Pair<String, Integer> getNextReplicaAddress() {
        if (this.replicaServerList.isEmpty()) {
            return this.leaderServer;
        }
        ++this.currentReplicaServerIndex;
        if (this.currentReplicaServerIndex > this.replicaServerList.size() - 1) {
            this.currentReplicaServerIndex = 0;
        }
        return this.replicaServerList.get(this.currentReplicaServerIndex);
    }

    boolean reloadClusterConfiguration() {
        Pair<String, Integer> oldLeader = this.leaderServer;
        for (int replicaIdx = 0; replicaIdx < this.replicaServerList.size(); ++replicaIdx) {
            Pair<String, Integer> connectToServer = this.replicaServerList.get(replicaIdx);
            this.currentServer = (String)connectToServer.getFirst();
            this.currentPort = (Integer)connectToServer.getSecond();
            try {
                this.requestClusterConfiguration();
            }
            catch (Exception e) {
                continue;
            }
            if (this.leaderServer == null) continue;
            return true;
        }
        if (oldLeader != null) {
            this.leaderServer = null;
            this.currentServer = (String)oldLeader.getFirst();
            this.currentPort = (Integer)oldLeader.getSecond();
            try {
                this.requestClusterConfiguration();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.leaderServer != null;
    }

    protected String getUrl(String command) {
        return "http://" + this.currentServer + ":" + this.currentPort + "/api/v" + this.apiVersion + "/" + command;
    }

    void setRequestPayload(HttpURLConnection connection, JSONObject jsonRequest) throws IOException {
        connection.setDoOutput(true);
        byte[] postData = jsonRequest.toString().getBytes(StandardCharsets.UTF_8);
        connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
        try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
            wr.write(postData);
        }
    }

    protected Exception manageException(HttpURLConnection connection, String operation) throws IOException {
        String detail = null;
        String reason = null;
        String exception = null;
        String exceptionArgs = null;
        String responsePayload = null;
        if (connection.getErrorStream() != null) {
            try {
                responsePayload = FileUtils.readStreamAsString((InputStream)connection.getErrorStream(), (String)charset);
                JSONObject response = new JSONObject(responsePayload);
                reason = response.getString("error");
                detail = response.has("detail") ? response.getString("detail") : null;
                exception = response.has("exception") ? response.getString("exception") : null;
                exceptionArgs = response.has("exceptionArgs") ? response.getString("exceptionArgs") : null;
            }
            catch (Exception e) {
                LogManager.instance().log((Object)this, Level.WARNING, "Error on executing command, retrying... (payload=%s, error=%s)", null, (Object)responsePayload, (Object)e.toString());
                return e;
            }
        }
        if (exception != null) {
            if (detail == null) {
                detail = "Unknown";
            }
            if (exception.equals(ServerIsNotTheLeaderException.class.getName())) {
                int sep = detail.lastIndexOf(46);
                return new ServerIsNotTheLeaderException(sep > -1 ? detail.substring(0, sep) : detail, exceptionArgs);
            }
            if (exception.equals(RecordNotFoundException.class.getName())) {
                int begin = detail.indexOf("#");
                int end = detail.indexOf(" ", begin);
                return new RecordNotFoundException(detail, new RID(detail.substring(begin, end)));
            }
            if (exception.equals(QuorumNotReachedException.class.getName())) {
                return new QuorumNotReachedException(detail);
            }
            if (exception.equals(DuplicatedKeyException.class.getName()) && exceptionArgs != null) {
                String[] exceptionArgsParts = exceptionArgs.split("\\|");
                return new DuplicatedKeyException(exceptionArgsParts[0], exceptionArgsParts[1], new RID(exceptionArgsParts[2]));
            }
            if (exception.equals(ConcurrentModificationException.class.getName())) {
                return new ConcurrentModificationException(detail);
            }
            if (exception.equals(TransactionException.class.getName())) {
                return new TransactionException(detail);
            }
            if (exception.equals(TimeoutException.class.getName())) {
                return new TimeoutException(detail);
            }
            if (exception.equals(SchemaException.class.getName())) {
                return new SchemaException(detail);
            }
            if (exception.equals(NoSuchElementException.class.getName())) {
                return new NoSuchElementException(detail);
            }
            if (exception.equals(SecurityException.class.getName())) {
                return new SecurityException(detail);
            }
            if (exception.equals("com.arcadedb.server.security.ServerSecurityException")) {
                return new SecurityException(detail);
            }
            if (exception.equals(ConnectException.class.getName())) {
                return new NeedRetryException(detail);
            }
            if (exception.equals("com.arcadedb.server.ha.ReplicationException")) {
                return new NeedRetryException(detail);
            }
            return new RemoteException("Error on executing remote operation " + operation + " (cause:" + exception + " detail:" + detail + ")");
        }
        String httpErrorDescription = connection.getResponseMessage();
        if (connection.getResponseCode() == 400 && "Bad Request".equals(httpErrorDescription) && "Command text is null".equals(reason)) {
            return new RemoteException("Empty payload received");
        }
        return new RemoteException("Error on executing remote command '" + operation + "' (httpErrorCode=" + connection.getResponseCode() + " httpErrorDescription=" + httpErrorDescription + " reason=" + reason + " detail=" + detail + " exception=" + exception + ")");
    }

    public static enum CONNECTION_STRATEGY {
        STICKY,
        ROUND_ROBIN;

    }

    public static interface Callback {
        public Object call(HttpURLConnection var1, JSONObject var2) throws Exception;
    }
}

