/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.Source;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.AbstractImporterFormat;
import com.arcadedb.integration.importer.vector.TextEmbeddingsImporter;
import java.io.IOException;

public class GloVeImporterFormat
extends AbstractImporterFormat {
    private TextEmbeddingsImporter importer;

    @Override
    public void load(SourceSchema sourceSchema, AnalyzedEntity.EntityType entityType, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws ImportException {
        context.parsed.set(0L);
        try {
            this.importer = new TextEmbeddingsImporter(database, parser.getSource().inputStream, settings).setContext(context);
            this.importer.run();
        }
        catch (Exception e) {
            throw new ImportException("Error on importing GloVe datasource", e);
        }
    }

    @Override
    public SourceSchema analyze(AnalyzedEntity.EntityType entityType, Parser parser, ImporterSettings settings, AnalyzedSchema analyzedSchema) throws IOException {
        return new SourceSchema(this, parser.getSource(), analyzedSchema);
    }

    @Override
    public void printProgress(ImporterSettings settings, ImporterContext context, Source source, Parser parser, ConsoleLogger logger) {
        if (this.importer != null) {
            this.importer.printProgress();
        }
    }

    @Override
    public String getFormat() {
        return "GloVe";
    }
}

