/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.Source;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.CSVImporterFormat;
import com.arcadedb.integration.importer.format.FormatImporter;
import com.arcadedb.integration.importer.format.GloVeImporterFormat;
import com.arcadedb.integration.importer.format.JSONImporterFormat;
import com.arcadedb.integration.importer.format.JsonlImporterFormat;
import com.arcadedb.integration.importer.format.Neo4jImporterFormat;
import com.arcadedb.integration.importer.format.OrientDBImporterFormat;
import com.arcadedb.integration.importer.format.RDFImporterFormat;
import com.arcadedb.integration.importer.format.Word2VecImporterFormat;
import com.arcadedb.integration.importer.format.XMLImporterFormat;
import com.arcadedb.log.LogManager;
import com.arcadedb.utility.Callable;
import com.arcadedb.utility.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SourceDiscovery {
    private static final String RESOURCE_SEPARATOR = ":::";
    private static final String FILE_PREFIX = "file://";
    private static final String CLASSPATH_PREFIX = "classpath://";
    private String url;
    private long limitBytes = 10000000L;
    private long limitEntries = 0L;

    public SourceDiscovery(String url) {
        this.url = url;
    }

    public SourceSchema getSchema(ImporterSettings settings, AnalyzedEntity.EntityType entityType, AnalyzedSchema analyzedSchema, ConsoleLogger logger) throws IOException {
        LogManager.instance().log((Object)this, Level.INFO, "Analyzing url: %s...", (Object)this.url);
        Source source = this.getSource();
        Parser parser = new Parser(source, 0L);
        FormatImporter formatImporter = this.analyzeSourceContent(parser, entityType, settings, logger);
        parser.reset();
        SourceSchema sourceSchema = null;
        sourceSchema = formatImporter.analyze(entityType, parser, settings, analyzedSchema);
        LogManager.instance().log((Object)this, Level.INFO, "Recognized format %s (parsingLimitBytes=%s parsingLimitEntries=%d)", (Object)formatImporter.getFormat(), (Object)FileUtils.getSizeAsString((long)this.limitBytes), (Object)this.limitEntries);
        if (sourceSchema != null && !sourceSchema.getOptions().isEmpty()) {
            for (Map.Entry<String, String> o : sourceSchema.getOptions().entrySet()) {
                LogManager.instance().log((Object)this, Level.INFO, "- %s = %s", (Object)o.getKey(), (Object)o.getValue());
            }
        }
        source.close();
        return sourceSchema;
    }

    public Source getSource() throws IOException {
        Source source = this.url.startsWith("http://") || this.url.startsWith("https://") ? this.getSourceFromURL(this.url) : this.getSourceFromFile(this.url);
        return source;
    }

    private Source getSourceFromURL(String url) throws IOException {
        int sep = url.lastIndexOf(RESOURCE_SEPARATOR);
        String urlPath = sep > -1 ? url.substring(0, sep) : url;
        String resource = sep > -1 ? url.substring(sep + RESOURCE_SEPARATOR.length()) : null;
        HttpURLConnection connection = (HttpURLConnection)new URL(urlPath).openConnection();
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.connect();
        return this.getSourceFromContent(new BufferedInputStream(connection.getInputStream()), connection.getContentLengthLong(), resource, (Callable<Void, Source>)((Callable)source -> {
            try {
                connection.disconnect();
                HttpURLConnection connection1 = (HttpURLConnection)new URL(urlPath).openConnection();
                connection1.setRequestMethod("GET");
                connection1.setDoOutput(true);
                connection1.connect();
                if (source.inputStream instanceof GZIPInputStream) {
                    source.inputStream = new GZIPInputStream(connection1.getInputStream(), 2048);
                } else {
                    InputStream patt0$temp = source.inputStream;
                    if (patt0$temp instanceof ZipInputStream) {
                        ZipInputStream stream = (ZipInputStream)patt0$temp;
                        source.inputStream = new ZipInputStream(connection1.getInputStream());
                        stream.getNextEntry();
                    } else {
                        source.inputStream = new BufferedInputStream(connection1.getInputStream());
                    }
                }
            }
            catch (Exception e) {
                throw new ImportException("Error on reset remote resource", e);
            }
            return null;
        }), () -> {
            connection.disconnect();
            return null;
        });
    }

    private Source getSourceFromFile(String path) throws IOException {
        InputStream fis;
        String resource;
        int sep = path.lastIndexOf(RESOURCE_SEPARATOR);
        String filePath = sep > -1 ? path.substring(0, sep) : path;
        String string = resource = sep > -1 ? path.substring(sep + RESOURCE_SEPARATOR.length()) : null;
        if (filePath.startsWith(FILE_PREFIX)) {
            filePath = filePath.substring(FILE_PREFIX.length());
        } else if (filePath.startsWith(CLASSPATH_PREFIX)) {
            filePath = filePath.substring(CLASSPATH_PREFIX.length());
            filePath = this.getClass().getClassLoader().getResource(filePath).getFile();
        }
        File file = new File(filePath);
        if (file.exists()) {
            fis = new BufferedInputStream(new FileInputStream(file));
        } else {
            fis = this.getClass().getClassLoader().getResourceAsStream(filePath);
            if (fis == null) {
                throw new FileNotFoundException(filePath);
            }
        }
        return this.getSourceFromContent(fis, file.length(), resource, (Callable<Void, Source>)((Callable)source -> {
            try {
                source.inputStream.close();
                if (source.inputStream instanceof GZIPInputStream) {
                    source.inputStream = new GZIPInputStream((InputStream)new FileInputStream(file), 2048);
                } else {
                    InputStream patt0$temp = source.inputStream;
                    if (patt0$temp instanceof ZipInputStream) {
                        ZipInputStream stream = (ZipInputStream)patt0$temp;
                        source.inputStream = new ZipInputStream(new FileInputStream(file));
                        stream.getNextEntry();
                    } else {
                        source.inputStream = new BufferedInputStream(new FileInputStream(file));
                    }
                }
            }
            catch (IOException e) {
                throw new ImportException("Error on reset local resource", e);
            }
            return null;
        }), () -> {
            fis.close();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FormatImporter analyzeSourceContent(Parser parser, AnalyzedEntity.EntityType entityType, ImporterSettings settings, ConsoleLogger logger) throws IOException {
        block38: {
            block36: {
                block37: {
                    knownFileType = null;
                    knownDelimiter = null;
                    switch (1.$SwitchMap$com$arcadedb$integration$importer$AnalyzedEntity$EntityType[entityType.ordinal()]) {
                        case 1: {
                            knownFileType = settings.documentsFileType != null ? settings.documentsFileType : this.getFileTypeByExtension(settings.documents);
                            knownDelimiter = settings.documentsDelimiter;
                            break;
                        }
                        case 2: {
                            knownFileType = settings.verticesFileType != null ? settings.verticesFileType : this.getFileTypeByExtension(settings.vertices);
                            knownDelimiter = settings.verticesDelimiter;
                            break;
                        }
                        case 3: {
                            knownFileType = settings.edgesFileType != null ? settings.edgesFileType : this.getFileTypeByExtension(settings.edgeTypeName);
                            knownDelimiter = settings.edgesDelimiter;
                            break;
                        }
                        case 4: {
                            knownFileType = this.getFileTypeByExtension(settings.url);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("entityType '" + String.valueOf((Object)entityType) + "' not supported");
                        }
                    }
                    if (knownFileType != null) {
                        if (knownFileType.equalsIgnoreCase("csv")) {
                            settings.options.put("delimiter", knownDelimiter);
                            return new CSVImporterFormat();
                        }
                        if (knownFileType.equalsIgnoreCase("json")) {
                            return new JSONImporterFormat();
                        }
                        if (knownFileType.equalsIgnoreCase("jsonl")) {
                            return new JsonlImporterFormat();
                        }
                        if (knownFileType.equalsIgnoreCase("xml")) {
                            return new XMLImporterFormat();
                        }
                        if (knownFileType.equalsIgnoreCase("graphml")) {
                            try {
                                clazz = Class.forName("com.arcadedb.gremlin.integration.importer.format.GraphMLImporterFormat");
                                return (FormatImporter)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                LogManager.instance().log((Object)this, Level.SEVERE, "Impossible to find importer for 'graphml' ", (Throwable)e);
                            }
                        } else if (knownFileType.equalsIgnoreCase("graphson")) {
                            try {
                                clazz = Class.forName("com.arcadedb.gremlin.integration.importer.format.GraphSONImporterFormat");
                                return (FormatImporter)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                LogManager.instance().log((Object)this, Level.SEVERE, "Impossible to find importer for 'graphson' ", (Throwable)e);
                            }
                        } else {
                            LogManager.instance().log((Object)this, Level.WARNING, "File type '%s' is not supported. Trying to understand file type...", (Object)knownFileType);
                        }
                    }
                    parser.nextChar();
                    format = this.analyzeChar(parser, settings);
                    if (format != null) {
                        return format;
                    }
                    parser.mark();
                    while (parser.isAvailable() && parser.getCurrentChar() == '#') {
                        this.skipLine(parser);
                        format = this.analyzeChar(parser, settings);
                        if (format == null) continue;
                        return format;
                    }
                    parser.reset();
                    try {
                        while (parser.getCurrentChar() == '/' && parser.nextChar() == '/') {
                            this.skipLine(parser);
                            format = this.analyzeChar(parser, settings);
                            if (format == null) continue;
                            var8_12 = format;
                            if (format == null) break block36;
                            break block37;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var15_21) {
                        if (format != null) {
                            logger.logLine(1, "Recognized format %s", new Object[]{format.getFormat()});
                        }
                        throw var15_21;
                    }
                }
                logger.logLine(1, "Recognized format %s", new Object[]{format.getFormat()});
            }
            return var8_12;
lbl-1000:
            // 1 sources

            {
                candidateSeparators = new HashMap<Character, AtomicInteger>();
                line = new StringBuilder();
                while (parser.isAvailable() && parser.nextChar() != '\n') {
                    c = parser.getCurrentChar();
                    line.append(c);
                    if (!this.isSeparator(c)) continue;
                    sep = (AtomicInteger)candidateSeparators.get(Character.valueOf(c));
                    if (sep == null) {
                        candidateSeparators.put(Character.valueOf(c), new AtomicInteger(1));
                        continue;
                    }
                    sep.incrementAndGet();
                }
                if (!candidateSeparators.isEmpty()) {
                    list = new ArrayList<Map.Entry<K, V>>(candidateSeparators.entrySet());
                    list.sort((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$analyzeSourceContent$4(java.util.Map$Entry java.util.Map$Entry ), (Ljava/util/Map$Entry;Ljava/util/Map$Entry;)I)());
                    bestSeparator = list.getFirst();
                    if (((Character)bestSeparator.getKey()).charValue() == ' ') {
                        line2 = new StringBuilder();
                        while (parser.isAvailable() && parser.nextChar() != '\n') {
                            line2.append(parser.getCurrentChar());
                        }
                        fields1 = line.toString().split(" ");
                        fields2 = line2.toString().split(" ");
                        if (fields1.length == 2 && fields2.length > 2) {
                            format = new Word2VecImporterFormat();
                        } else if (fields1.length == fields2.length) {
                            format = new GloVeImporterFormat();
                        }
                    }
                    if (format == null) {
                        LogManager.instance().log((Object)this, Level.INFO, "Best separator candidate='%s' (all candidates=%s)", bestSeparator.getKey(), list);
                        settings.options.put("delimiter", String.valueOf(bestSeparator.getKey()));
                        format = new CSVImporterFormat();
                    }
                }
                if (format == null) break block38;
            }
            logger.logLine(1, "Recognized format %s", new Object[]{format.getFormat()});
        }
        if (format != null) {
            return format;
        }
        throw new ImportException("Cannot determine the file type. If it is a CSV file, please specify the header via settings");
    }

    private boolean isSeparator(char c) {
        return c == ' ' || c == '\t' || c == ',' || c == '|' || c == '-' || c == '_';
    }

    private String getFileTypeByExtension(String fileName) {
        return switch (this.getFormatFromExtension(fileName)) {
            case "csv" -> "csv";
            case "graphml" -> "graphml";
            case "graphson" -> "graphson";
            case "jsonl" -> "jsonl";
            default -> null;
        };
    }

    private void skipLine(Parser parser) throws IOException {
        while (parser.isAvailable() && parser.nextChar() != '\n') {
        }
    }

    private FormatImporter analyzeChar(Parser parser, ImporterSettings settings) throws IOException {
        char currentChar = parser.getCurrentChar();
        if (currentChar == '<') {
            int beginTag = 1;
            int endTag = 0;
            boolean insideTag = true;
            ArrayList<Character> delimiters = new ArrayList<Character>();
            while (parser.isAvailable() && parser.nextChar() != '\n') {
                char c = parser.getCurrentChar();
                if (insideTag) {
                    if (c != '>') continue;
                    ++endTag;
                    insideTag = false;
                    continue;
                }
                if (c == '<') {
                    ++beginTag;
                    insideTag = true;
                    continue;
                }
                delimiters.add(Character.valueOf(c));
            }
            if (!delimiters.isEmpty() && beginTag == endTag) {
                boolean allDelimitersAreTheSame = true;
                char delimiter = ((Character)delimiters.getFirst()).charValue();
                for (int i = 1; i < delimiters.size() - 1; ++i) {
                    if (((Character)delimiters.get(i)).charValue() == delimiter) continue;
                    allDelimitersAreTheSame = false;
                    break;
                }
                if (allDelimitersAreTheSame) {
                    settings.typeIdProperty = "id";
                    settings.options.put("delimiter", String.valueOf(delimiters.getFirst()));
                    return new RDFImporterFormat();
                }
            }
            if (delimiters.size() <= 1) {
                return new XMLImporterFormat();
            }
        } else if (currentChar == '{') {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < 1024 && parser.isAvailable() && (currentChar = parser.nextChar()) != '}'; ++i) {
                buffer.append(currentChar);
            }
            if (buffer.toString().startsWith("\"info\":{\"name\":\"")) {
                return new OrientDBImporterFormat();
            }
            if (buffer.toString().startsWith("\"type\":\"node\",\"id\":\"")) {
                return new Neo4jImporterFormat();
            }
            return new JSONImporterFormat();
        }
        return null;
    }

    protected void parseParameters(String[] args) {
        for (int i = 0; i < args.length - 1; i += 2) {
            this.parseParameter(args[i], args[i + 1]);
        }
        if (this.url == null) {
            throw new IllegalArgumentException("Missing URL");
        }
    }

    protected void parseParameter(String name, String value) {
        if ("url".equals(name)) {
            this.url = value;
        } else if ("analyzeLimitBytes".equals(name)) {
            this.limitBytes = FileUtils.getSizeAsNumber((Object)value);
        } else if ("analyzeLimitEntries".equals(name)) {
            this.limitEntries = Long.parseLong(value);
        } else {
            throw new IllegalArgumentException("Invalid setting '" + name + "'");
        }
    }

    private Source getSourceFromContent(InputStream in, long totalSize, String resource, Callable<Void, Source> resetCallback, java.util.concurrent.Callable<Void> closeCallback) throws IOException {
        in.mark(0);
        ZipInputStream zip = new ZipInputStream(in);
        ZipEntry entry = zip.getNextEntry();
        if (entry != null) {
            if (resource != null) {
                while (entry != null) {
                    if (resource.equals(entry.getName())) {
                        return new Source(this.url, zip, totalSize, true, resetCallback, closeCallback);
                    }
                    zip.closeEntry();
                    entry = zip.getNextEntry();
                }
                throw new IllegalArgumentException("Resource '" + resource + "' not found");
            }
            return new Source(this.url, zip, totalSize, true, resetCallback, closeCallback);
        }
        in.reset();
        in.mark(in.available());
        try {
            GZIPInputStream gzip = new GZIPInputStream(in, 8192);
            return new Source(this.url, gzip, totalSize, true, resetCallback, closeCallback);
        }
        catch (IOException iOException) {
            in.reset();
            return new Source(this.url, in, totalSize, false, resetCallback, closeCallback);
        }
    }

    private String getFormatFromExtension(String fileName) {
        if (fileName.lastIndexOf(File.separator) > -1) {
            fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
        }
        if (fileName.endsWith(".tgz")) {
            fileName = fileName.substring(0, fileName.length() - ".tgz".length());
        } else if (fileName.endsWith(".gz")) {
            fileName = fileName.substring(0, fileName.length() - ".gz".length());
        } else if (fileName.endsWith(".zip")) {
            fileName = fileName.substring(0, fileName.length() - ".zip".length());
        }
        if (fileName.lastIndexOf(46) > -1) {
            fileName = fileName.substring(fileName.lastIndexOf(46) + 1);
        }
        return fileName;
    }

    private static /* synthetic */ int lambda$analyzeSourceContent$4(Map.Entry o1, Map.Entry o2) {
        if (((AtomicInteger)o1.getValue()).get() == ((AtomicInteger)o2.getValue()).get()) {
            return 0;
        }
        return ((AtomicInteger)o1.getValue()).get() < ((AtomicInteger)o2.getValue()).get() ? 1 : -1;
    }
}

