/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.Constants;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.BasicDatabase;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.MutableEmbeddedDocument;
import com.arcadedb.database.RID;
import com.arcadedb.database.Record;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.index.CompressedRID2RIDIndex;
import com.arcadedb.index.Index;
import com.arcadedb.index.lsm.LSMTreeIndexAbstract;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.LocalEdgeType;
import com.arcadedb.schema.LocalVertexType;
import com.arcadedb.schema.Property;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.Type;
import com.arcadedb.schema.VertexType;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.utility.FileUtils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;

public class OrientDBImporter {
    private static final int CONCURRENT_MAX_RETRY = 3;
    private final File file;
    private final Map<String, OrientDBClass> classes = new LinkedHashMap<String, OrientDBClass>();
    private final Map<String, Long> totalRecordByType = new HashMap<String, Long>();
    private final Set<String> excludeClasses = Set.of("OUser", "ORole", "OSchedule", "OSequence", "OTriggered", "OSecurityPolicy", "ORestricted", "OIdentity", "OFunction", "_studio");
    private final Set<String> edgeClasses = new HashSet<String>();
    private final List<Map<String, Object>> parsedUsers = new ArrayList<Map<String, Object>>();
    private CompressedRID2RIDIndex compressedRecordsRidMap;
    private final Set<RID> documentsWithLinksToUpdate = new HashSet<RID>();
    private final Map<String, AtomicLong> totalEdgesByVertexType = new HashMap<String, AtomicLong>();
    private final ImporterSettings settings;
    private List<Map<String, Object>> parsedIndexes;
    private final ConsoleLogger logger;
    private String databasePath;
    private String inputFile;
    private String databaseName;
    private boolean createSecurityFiles = false;
    private boolean overwriteDatabase = false;
    private long totalAttributesParsed = 0L;
    private long errors = 0L;
    private long warnings = 0L;
    private DatabaseFactory factory;
    private Database database;
    private int batchSize = 10000;
    private Phase phase = Phase.OFF;
    private long skippedRecordBecauseNullKey = 0L;
    private long skippedEdgeBecauseMissingVertex = 0L;
    private long beginTime;
    private long beginTimeRecordsCreation;
    private long beginTimeEdgeCreation;
    private JsonReader reader;
    private boolean error = false;
    private ImporterContext context = new ImporterContext();

    public OrientDBImporter(String[] args) {
        this.settings = new ImporterSettings();
        String state = null;
        block12: for (String arg : args) {
            if (arg.equals("-?")) {
                this.printHelp();
                continue;
            }
            if (arg.equals("-d")) {
                state = "databasePath";
                continue;
            }
            if (arg.equals("-i")) {
                state = "inputFile";
                continue;
            }
            if (arg.equals("-s")) {
                this.createSecurityFiles = true;
                continue;
            }
            if (arg.equals("-o")) {
                this.overwriteDatabase = true;
                continue;
            }
            if (arg.equals("-b")) {
                state = "batchSize";
                continue;
            }
            if (arg.equals("-v")) {
                state = "verboseLevel";
                continue;
            }
            if (state == null) continue;
            switch (state) {
                case "databasePath": {
                    this.databasePath = arg;
                    continue block12;
                }
                case "inputFile": {
                    this.inputFile = arg;
                    continue block12;
                }
                case "batchSize": {
                    this.batchSize = Integer.parseInt(arg);
                    continue block12;
                }
                case "verboseLevel": {
                    this.settings.verboseLevel = Integer.parseInt(arg);
                }
            }
        }
        this.logger = new ConsoleLogger(this.settings.verboseLevel);
        this.printHeader();
        if (this.inputFile == null) {
            this.syntaxError("Missing input file. Use -f <file-path>");
        }
        this.file = new File(this.inputFile);
    }

    public OrientDBImporter(DatabaseInternal database, ImporterSettings settings) throws ClassNotFoundException {
        this.settings = settings;
        this.database = database;
        this.databasePath = database.getDatabasePath();
        this.batchSize = settings.commitEvery;
        this.file = null;
        this.logger = new ConsoleLogger(settings.verboseLevel);
    }

    public static void main(String[] args) throws Exception {
        new OrientDBImporter(args).run();
    }

    public GZIPInputStream openInputStream() throws IOException {
        return new GZIPInputStream(new FileInputStream(this.file));
    }

    public Database run() throws IOException, ClassNotFoundException {
        String from;
        if (this.file != null && !this.file.exists()) {
            this.error = true;
            throw new IllegalArgumentException("File '" + this.inputFile + "' not found");
        }
        String string = from = this.inputFile != null ? "'" + this.inputFile + "'" : "stream";
        if (this.databasePath == null) {
            this.logger.logLine(1, "Checking OrientDB database from %s...", from);
        } else {
            this.logger.logLine(1, "Importing OrientDB database from %s to '%s'", from, this.databasePath);
            if (!this.createDatabase()) {
                return null;
            }
        }
        this.beginTime = System.currentTimeMillis();
        if (this.settings.expectedVertices < 1L) {
            this.phase = Phase.ANALYZE;
            this.logger.logLine(1, "No `expectedVertex` setting specified: parsing the file to count the total documents and vertex", new Object[0]);
            this.parseInputFile();
            this.settings.expectedVertices = this.context.parsedDocumentAndVertices.get();
            if (this.settings.expectedVertices < 1L) {
                this.settings.expectedVertices = 500000L;
                this.logger.logLine(1, "Cannot find any documents or vertices", new Object[0]);
            }
        }
        this.compressedRecordsRidMap = new CompressedRID2RIDIndex(this.database, (int)this.settings.expectedVertices, (int)this.settings.expectedEdges);
        this.phase = Phase.CREATE_SCHEMA;
        this.totalAttributesParsed = 0L;
        this.logger.logLine(1, "Creation of the schema: types, properties and indexes", new Object[0]);
        this.parseInputFile();
        this.phase = Phase.CREATE_EDGES;
        this.logger.logLine(1, "Creation of edges started: creating edges between vertices", new Object[0]);
        this.beginTimeEdgeCreation = System.currentTimeMillis();
        this.parseInputFile();
        this.createIndexes();
        if (this.database.getSchema().existsType("V") && this.database.countType("V", false) == 0L) {
            this.logger.logLine(2, "Dropping empty 'V' base vertex type (in OrientDB all the vertices have their own class", new Object[0]);
            this.database.getSchema().dropType("V");
        }
        if (this.database.getSchema().existsType("E") && this.database.countType("E", false) == 0L) {
            this.logger.logLine(2, "Dropping empty 'E' base edge type (in OrientDB all the edges have their own class", new Object[0]);
            this.database.getSchema().dropType("E");
        }
        long elapsed = (System.currentTimeMillis() - this.beginTime) / 1000L;
        long totalRecords = 0L;
        for (Long l : this.totalRecordByType.values()) {
            totalRecords += l.longValue();
        }
        this.logger.logLine(1, "***************************************************************************************************", new Object[0]);
        this.logger.logLine(1, "Import of OrientDB database completed in %,d secs with %,d errors and %,d warnings.", elapsed, this.errors, this.warnings);
        this.logger.logLine(1, "\nSUMMARY\n", new Object[0]);
        this.logger.logLine(1, "- Records..................................: %,d", totalRecords);
        for (Map.Entry entry : this.classes.entrySet()) {
            String className = (String)entry.getKey();
            Long recordsByClass = this.totalRecordByType.get(className);
            long entries = recordsByClass != null ? recordsByClass : 0L;
            String additional = "";
            if (this.excludeClasses.contains(className)) {
                additional = " (excluded)";
            }
            this.logger.logLine(1, "-- %-40s: %,d %s", className, entries, additional);
        }
        this.logger.logLine(1, "- Total attributes.........................: %,d", this.totalAttributesParsed);
        this.logger.logLine(1, "***************************************************************************************************", new Object[0]);
        this.logger.logLine(1, "", new Object[0]);
        this.logger.logLine(1, "NOTES:", new Object[0]);
        if (this.createSecurityFiles) {
            this.writeSecurityFiles();
            this.logger.logLine(1, "- generated file server-users.jsonl to copy under ArcadeDB server 'config' directory. If the server already contains users, instead of replacing it, you can append the content", new Object[0]);
        } else {
            this.logger.logLine(1, "- users stored in OUser class will not be imported because ArcadeDB has users only at server level. If you want to import such users into ArcadeDB server configuration, please run the importer with the option -s <securityFileDirectory>", new Object[0]);
        }
        if (this.database != null) {
            this.logger.logLine(1, "- you can find your new ArcadeDB database in '" + this.database.getDatabasePath() + "'", new Object[0]);
        }
        return this.database;
    }

    private boolean createDatabase() {
        if (this.database == null) {
            this.factory = new DatabaseFactory(this.databasePath);
            if (this.factory.exists()) {
                if (!this.overwriteDatabase) {
                    this.logger.errorLine("Database already exists on path '%s'", this.databasePath);
                    ++this.errors;
                    return false;
                }
                this.database = this.factory.open();
                this.logger.errorLine("Found existent database at '%s', dropping it and recreate a new one", this.databasePath);
                this.database.drop();
            }
            this.database = this.factory.create();
        }
        return true;
    }

    public boolean isError() {
        return this.error;
    }

    public ImporterContext getContext() {
        return this.context;
    }

    public OrientDBImporter setContext(ImporterContext context) {
        this.context = context;
        return this;
    }

    private void parseInputFile() throws IOException {
        GZIPInputStream inputStream = this.openInputStream();
        this.reader = new JsonReader((Reader)new InputStreamReader((InputStream)inputStream, DatabaseFactory.getDefaultCharset()));
        this.reader.setLenient(true);
        this.reader.beginObject();
        block14: while (this.reader.hasNext()) {
            switch (this.reader.nextName()) {
                case "info": {
                    this.parseDatabaseInfo();
                    continue block14;
                }
                case "clusters": {
                    this.parseClusters();
                    continue block14;
                }
                case "schema": {
                    this.parseSchema();
                    continue block14;
                }
                case "records": {
                    this.parseRecords();
                    continue block14;
                }
            }
            try {
                this.reader.skipValue();
            }
            catch (EOFException e) {
                return;
            }
        }
        this.reader.endObject();
    }

    private void writeSecurityFiles() throws IOException {
        File securityFile = new File("./server-users.jsonl");
        StringBuilder buffer = new StringBuilder();
        for (Map<String, Object> u : this.parsedUsers) {
            JSONObject user = new JSONObject();
            user.put("name", u.get("name"));
            user.put("password", u.get("password"));
            user.put("databases", (Object)new JSONArray(new String[]{this.databaseName}));
            buffer.append(user).append("\n");
        }
        FileUtils.writeFile((File)securityFile, (String)buffer.toString());
    }

    private void parseRecords() throws IOException {
        this.reader.beginArray();
        AtomicLong processedItems = new AtomicLong();
        this.context.skippedEdges.set(0L);
        this.context.parsed.set(0L);
        ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>(this.batchSize);
        while (this.reader.peek() == JsonToken.BEGIN_OBJECT) {
            for (int i = 0; i < this.batchSize && this.reader.peek() == JsonToken.BEGIN_OBJECT; ++i) {
                Map<String, Object> attributes = this.parseRecord(this.reader, false);
                batch.add(attributes);
                this.context.parsed.incrementAndGet();
                if (this.reader.peek() != JsonToken.NULL) continue;
                this.reader.skipValue();
            }
            this.database.transaction(() -> {
                try {
                    this.executeBatch(processedItems, batch);
                }
                catch (IOException e) {
                    throw new ImportException("Error on importing batch of records", e);
                }
            }, false, 3);
            batch.clear();
        }
        long elapsedInSecs = (System.currentTimeMillis() - this.beginTime) / 1000L;
        switch (this.phase.ordinal()) {
            case 1: {
                break;
            }
            case 3: {
                this.logger.logLine(1, "Creation of records completed: created %,d vertices and %,d documents, skipped %,d edges (%,d records/sec elapsed=%,d secs)", this.context.createdVertices.get(), this.context.createdDocuments.get(), this.context.skippedEdges.get(), elapsedInSecs > 0L ? (this.context.createdDocuments.get() + this.context.createdVertices.get()) / elapsedInSecs : 0L, elapsedInSecs);
                this.updateDocumentLinks();
                break;
            }
            case 4: {
                this.logger.logLine(1, "Creation of edges completed: created %,d edges %s (%,d edges/sec elapsed=%,d secs)", this.context.createdEdges.get(), this.totalEdgesByVertexType, elapsedInSecs > 0L ? this.context.createdEdges.get() / elapsedInSecs : 0L, elapsedInSecs);
                break;
            }
            default: {
                ++this.errors;
                this.error = true;
                throw new IllegalArgumentException("Invalid phase " + String.valueOf((Object)this.phase));
            }
        }
        this.reader.endArray();
    }

    private void executeBatch(AtomicLong processedItems, List<Map<String, Object>> batch) throws IOException {
        for (int i = 0; i < batch.size(); ++i) {
            Map<String, Object> attributes = batch.get(i);
            String className = (String)attributes.get("@class");
            if (this.phase == Phase.CREATE_SCHEMA || this.phase == Phase.CREATE_RECORDS) {
                this.createRecords(processedItems, attributes, className);
            } else if (this.phase == Phase.CREATE_EDGES) {
                this.createEdges(processedItems, attributes, className);
            } else if (this.phase == Phase.ANALYZE && !this.edgeClasses.contains(className)) {
                this.context.parsedDocumentAndVertices.incrementAndGet();
            }
            processedItems.incrementAndGet();
        }
    }

    private void updateDocumentLinks() {
        if (!this.documentsWithLinksToUpdate.isEmpty()) {
            this.logger.logLine(1, "Updating LINKs in %,d documents...", this.documentsWithLinksToUpdate.size());
            this.database.begin();
            for (RID rid : this.documentsWithLinksToUpdate) {
                MutableDocument record = this.database.lookupByRID(rid, true).asDocument().modify();
                for (String pName : record.getPropertyNames()) {
                    Object pValue = record.get(pName);
                    RID converted = this.convertRIDs(pValue);
                    if (converted == null) continue;
                    record.set(pName, (Object)converted);
                }
                record.save();
                this.context.updatedDocuments.incrementAndGet();
                if (this.context.updatedDocuments.get() <= 0L || this.context.updatedDocuments.get() % (long)this.batchSize != 0L) continue;
                this.database.commit();
                this.database.begin();
            }
            this.database.commit();
            this.logger.logLine(1, "- Updated LINKs in %,d records", this.context.updatedDocuments.get());
        }
    }

    private RID convertRID(Object value) {
        RID rid1;
        RID rid = value instanceof RID ? (rid1 = (RID)value) : new RID((BasicDatabase)this.database, value.toString());
        return this.compressedRecordsRidMap.get(rid);
    }

    private RID convertRIDs(Object pValue) {
        block8: {
            block7: {
                if (RID.is((Object)pValue)) {
                    return this.convertRID(pValue);
                }
                if (!(pValue instanceof List)) break block7;
                List list = (List)pValue;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (RID.is(item)) {
                        list.set(i, this.convertRID(item));
                        continue;
                    }
                    if (item instanceof List) {
                        this.convertRIDs(item);
                        continue;
                    }
                    if (!(item instanceof Map)) continue;
                    this.convertRIDs(item);
                }
                break block8;
            }
            if (!(pValue instanceof Map)) break block8;
            Map map = (Map)pValue;
            ArrayList keys = new ArrayList(map.keySet());
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                Object value = map.get(key);
                if (RID.is(value)) {
                    map.put(key, this.convertRID(value));
                    continue;
                }
                if (value instanceof List) {
                    this.convertRIDs(value);
                    continue;
                }
                if (!(value instanceof Map)) continue;
                this.convertRIDs(value);
            }
        }
        return null;
    }

    private void createEdges(AtomicLong processedItems, Map<String, Object> attributes, String className) {
        if (this.edgeClasses.contains(className)) {
            this.createEdges(attributes);
            if (processedItems.get() > 0L && processedItems.get() % 1000000L == 0L) {
                long elapsed = System.currentTimeMillis() - this.beginTimeEdgeCreation;
                this.logger.logLine(2, "- Status update: created %,d edges %s (%,d edges/sec)", this.context.createdEdges.get(), this.totalEdgesByVertexType, this.context.createdEdges.get() / elapsed * 1000L);
            }
        }
    }

    private void createRecords(AtomicLong processedItems, Map<String, Object> attributes, String className) throws IOException {
        if (!this.edgeClasses.contains(className)) {
            this.createRecord(attributes);
        } else {
            this.context.skippedEdges.incrementAndGet();
        }
        if (processedItems.get() > 0L && processedItems.get() % 1000000L == 0L) {
            long elapsed = System.currentTimeMillis() - this.beginTimeRecordsCreation;
            this.logger.logLine(2, "- Status update: created %,d vertices and %,d documents, skipped %,d edges (%,d records/sec)", this.context.createdVertices.get(), this.context.createdDocuments.get(), this.context.skippedEdges.get(), (this.context.createdDocuments.get() + this.context.createdVertices.get()) / elapsed * 1000L);
        }
    }

    private MutableDocument createRecord(Map<String, Object> attributes) throws IOException {
        MutableVertex record = null;
        String rid = (String)attributes.get("@rid");
        if (rid == null) {
            return null;
        }
        RID recordRid = new RID((BasicDatabase)this.database, rid);
        String recordType = (String)attributes.get("@type");
        if (recordType != null) {
            switch (recordType) {
                case "b": {
                    if (recordRid.getBucketId() == 0 && recordRid.getPosition() == 0L) break;
                    this.logger.errorLine("- Unsupported binary record. Ignoring record: %s", attributes);
                    ++this.warnings;
                    break;
                }
                case "d": {
                    String className = (String)attributes.get("@class");
                    if (className == null) {
                        if (recordRid.getBucketId() == 0 && recordRid.getPosition() == 1L) break;
                        if (recordRid.getBucketId() == 0 && recordRid.getPosition() == 2L) {
                            this.parsedIndexes = (List)attributes.get("indexes");
                            if (this.phase != Phase.CREATE_SCHEMA) break;
                            this.logger.logLine(1, "Creation of records started: creating vertices and documents records (edges on the next phase)", new Object[0]);
                            this.phase = Phase.CREATE_RECORDS;
                            this.beginTimeRecordsCreation = System.currentTimeMillis();
                            break;
                        }
                        this.logger.errorLine("- Unsupported record without class. Ignoring record: %s", attributes);
                        ++this.warnings;
                        break;
                    }
                    if (className.equals("OUser")) {
                        this.parsedUsers.add(attributes);
                    }
                    this.incrementRecordByClass(className);
                    if (this.excludeClasses.contains(className)) break;
                    DocumentType type = this.database.getSchema().getType(className);
                    if (!this.checkForNullIndexes(attributes, type)) {
                        return null;
                    }
                    if (type instanceof LocalVertexType) {
                        record = this.database.newVertex(className);
                    } else {
                        if (type instanceof LocalEdgeType) {
                            return null;
                        }
                        record = this.database.newDocument(className);
                    }
                    boolean rememberToUpdateThisDocumentBecauseContainsLinks = this.containsLinks((Record)record, attributes);
                    for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                        String attrName = entry.getKey();
                        if (attrName.startsWith("@")) continue;
                        Object attrValue = entry.getValue();
                        if (attrValue instanceof Map) {
                            Map attrValueMap = (Map)attrValue;
                            if (attrValueMap.containsKey("@class")) {
                                if (!attrValueMap.containsKey("@rid")) {
                                    this.createEmbeddedDocument((MutableDocument)record, attrName, attrValueMap);
                                    continue;
                                }
                                attrValue = this.createRecord(attrValueMap);
                            }
                        } else if (attrValue instanceof List && record instanceof Vertex && (attrName.startsWith("out_") || attrName.startsWith("in_"))) {
                            attrValue = null;
                        }
                        if (attrValue == null) continue;
                        record.set(attrName, attrValue);
                    }
                    record.save();
                    RID recordRID = record.getIdentity();
                    if (type instanceof LocalVertexType) {
                        this.context.createdVertices.incrementAndGet();
                    } else {
                        this.context.createdDocuments.incrementAndGet();
                    }
                    this.compressedRecordsRidMap.put(recordRid, recordRID);
                    if (!rememberToUpdateThisDocumentBecauseContainsLinks) break;
                    this.documentsWithLinksToUpdate.add(recordRID);
                    this.context.documentsWithLinksToUpdate.set(this.documentsWithLinksToUpdate.size());
                    break;
                }
                default: {
                    ++this.errors;
                    this.logger.errorLine("- Unsupported record type '%s'", recordType);
                }
            }
        }
        return record;
    }

    private boolean containsLinks(Record record, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String entryName = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                if (!this.containsLinks(null, (Map)entryValue)) continue;
                return true;
            }
            if (entryValue instanceof List) {
                if (record instanceof Vertex && (entryName.startsWith("out_") || entryName.startsWith("in_"))) continue;
                List list = (List)entryValue;
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (!(item instanceof Map)) continue;
                    if (this.containsLinks(null, (Map)item)) {
                        return true;
                    }
                    if (!RID.is(item)) continue;
                    return true;
                }
                continue;
            }
            if (!RID.is((Object)entryValue)) continue;
            return true;
        }
        return false;
    }

    private MutableEmbeddedDocument createEmbeddedDocument(MutableDocument record, String propertyName, Map<String, Object> attributes) throws IOException {
        MutableEmbeddedDocument embedded = null;
        String className = (String)attributes.remove("@class");
        this.incrementRecordByClass(className);
        this.context.parsed.incrementAndGet();
        if (!this.excludeClasses.contains(className)) {
            embedded = record.newEmbeddedDocument(className, propertyName);
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                Object attrValue;
                String attrName = entry.getKey();
                if (attrName.startsWith("@") || (attrValue = entry.getValue()) == null) continue;
                embedded.set(attrName, attrValue);
            }
            this.context.createdEmbeddedDocuments.incrementAndGet();
        }
        return embedded;
    }

    private void createEdges(Map<String, Object> attributes) {
        String recordType = (String)attributes.get("@type");
        if (recordType == null || !recordType.equals("d")) {
            return;
        }
        String className = (String)attributes.get("@class");
        if (className == null) {
            return;
        }
        if (this.excludeClasses.contains(className)) {
            return;
        }
        DocumentType type = this.database.getSchema().getType(className);
        if (!(type instanceof LocalEdgeType)) {
            return;
        }
        if (!this.checkForNullIndexes(attributes, type)) {
            return;
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
            if (attr.getKey().startsWith("@") || attr.getKey().equals("out") || attr.getKey().equals("in")) continue;
            properties.put(attr.getKey(), attr.getValue());
        }
        RID out = new RID((BasicDatabase)this.database, (String)attributes.get("out"));
        RID newOut = this.compressedRecordsRidMap.get(out);
        if (newOut == null) {
            ++this.skippedEdgeBecauseMissingVertex;
            ++this.warnings;
            if (this.settings.verboseLevel < 3 && this.skippedEdgeBecauseMissingVertex == 100L) {
                this.logger.logLine(2, "- Skipped 100 edges because one vertex is not in the database. Not reporting further case to reduce the output", new Object[0]);
            } else if (this.settings.verboseLevel > 2 || this.skippedEdgeBecauseMissingVertex < 100L) {
                this.logger.logLine(2, "- Skip edge %s because source vertex (out) was not imported", attributes);
            }
            return;
        }
        RID in = new RID((BasicDatabase)this.database, (String)attributes.get("in"));
        RID newIn = this.compressedRecordsRidMap.get(in);
        if (newIn == null) {
            ++this.skippedEdgeBecauseMissingVertex;
            ++this.warnings;
            if (this.settings.verboseLevel < 3 && this.skippedEdgeBecauseMissingVertex == 100L) {
                this.logger.logLine(2, "- Skipped 100 edges because one vertex is not in the database. Not reporting further case to reduce the output", new Object[0]);
            } else if (this.settings.verboseLevel > 2 || this.skippedEdgeBecauseMissingVertex < 100L) {
                this.logger.logLine(2, "- Skip edge %s because destination vertex (in) was not imported", attributes);
            }
            return;
        }
        Vertex sourceVertex = (Vertex)this.database.lookupByRID(newOut, false);
        sourceVertex.newEdge(className, (Identifiable)newIn, new Object[]{properties});
        this.context.createdEdges.incrementAndGet();
        AtomicLong edgesByVertexType = this.totalEdgesByVertexType.computeIfAbsent(className, k -> new AtomicLong());
        edgesByVertexType.incrementAndGet();
        this.incrementRecordByClass(className);
    }

    private Map<String, Object> parseRecord(JsonReader reader, boolean ignore) throws IOException {
        LinkedHashMap<String, Object> attributes = ignore ? null : new LinkedHashMap<String, Object>();
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            String attributeName = reader.nextName();
            Object attributeValue = this.parseAttributeValue(reader, attributeName, ignore);
            if (ignore) continue;
            attributes.put(attributeName, attributeValue);
            ++this.totalAttributesParsed;
        }
        reader.endObject();
        return attributes;
    }

    private Object parseAttributeValue(JsonReader reader, String attributeName, boolean ignore) throws IOException {
        Object attributeValue = null;
        JsonToken propertyType = reader.peek();
        switch (propertyType) {
            case STRING: {
                attributeValue = reader.nextString();
                break;
            }
            case NUMBER: {
                attributeValue = reader.nextDouble();
                break;
            }
            case BOOLEAN: {
                attributeValue = reader.nextBoolean();
                break;
            }
            case NULL: {
                reader.nextNull();
                attributeValue = null;
                break;
            }
            case BEGIN_OBJECT: {
                attributeValue = this.parseRecord(reader, ignore);
                break;
            }
            case BEGIN_ARRAY: {
                attributeValue = this.parseArray(reader, ignore);
                break;
            }
            default: {
                this.logger.logLine(2, "Skipping property '%s' of type '%s'", attributeName, propertyType);
                ++this.errors;
            }
        }
        return attributeValue;
    }

    private List<Object> parseArray(JsonReader reader, boolean ignore) throws IOException {
        ArrayList<Object> list = ignore ? null : new ArrayList<Object>();
        reader.beginArray();
        block8: while (reader.peek() != JsonToken.END_ARRAY) {
            Object entryValue;
            JsonToken entryType = reader.peek();
            switch (entryType) {
                case STRING: {
                    entryValue = reader.nextString();
                    break;
                }
                case NUMBER: {
                    entryValue = reader.nextDouble();
                    break;
                }
                case BOOLEAN: {
                    entryValue = reader.nextBoolean();
                    break;
                }
                case NULL: {
                    reader.nextNull();
                    entryValue = null;
                    break;
                }
                case BEGIN_OBJECT: {
                    entryValue = this.parseRecord(reader, ignore);
                    break;
                }
                case BEGIN_ARRAY: {
                    entryValue = this.parseArray(reader, ignore);
                    break;
                }
                default: {
                    ++this.errors;
                    this.logger.logLine(2, "Skipping entry of type '%s'", entryType);
                    continue block8;
                }
            }
            if (ignore) continue;
            list.add(entryValue);
        }
        reader.endArray();
        return list;
    }

    private void parseSchema() throws IOException {
        this.reader.beginObject();
        block45: while (this.reader.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = this.reader.nextName()) {
                case "classes": {
                    this.reader.beginArray();
                    while (this.reader.peek() != JsonToken.END_ARRAY) {
                        this.reader.beginObject();
                        OrientDBClass cls = new OrientDBClass();
                        block47: while (this.reader.peek() != JsonToken.END_OBJECT) {
                            String attrName;
                            switch (attrName = this.reader.nextName()) {
                                case "name": {
                                    cls.name = this.reader.nextString();
                                    continue block47;
                                }
                                case "cluster-ids": {
                                    this.reader.beginArray();
                                    while (this.reader.peek() != JsonToken.END_ARRAY) {
                                        cls.clusterIds.add(this.reader.nextInt());
                                    }
                                    this.reader.endArray();
                                    continue block47;
                                }
                                case "super-classes": {
                                    this.reader.beginArray();
                                    while (this.reader.peek() != JsonToken.END_ARRAY) {
                                        cls.superClasses.add(this.reader.nextString());
                                    }
                                    this.reader.endArray();
                                    continue block47;
                                }
                                case "properties": {
                                    String propertyName = null;
                                    this.reader.beginArray();
                                    while (this.reader.peek() != JsonToken.END_ARRAY) {
                                        this.reader.beginObject();
                                        OrientDBProperty propertyType = new OrientDBProperty();
                                        block51: while (this.reader.peek() != JsonToken.END_OBJECT) {
                                            String pName;
                                            switch (pName = this.reader.nextName()) {
                                                case "name": {
                                                    propertyName = this.reader.nextString();
                                                    continue block51;
                                                }
                                                case "type": {
                                                    propertyType.type = this.reader.nextString();
                                                    continue block51;
                                                }
                                                case "linkedType": 
                                                case "linkedClass": {
                                                    propertyType.ofType = this.reader.nextString();
                                                    continue block51;
                                                }
                                                case "customFields": {
                                                    propertyType.customFields = this.parseRecord(this.reader, false);
                                                    if (!propertyType.customFields.isEmpty()) continue block51;
                                                    propertyType.customFields = null;
                                                    continue block51;
                                                }
                                                case "mandatory": {
                                                    propertyType.mandatory = this.reader.nextBoolean();
                                                    continue block51;
                                                }
                                                case "readonly": {
                                                    propertyType.readOnly = this.reader.nextBoolean();
                                                    continue block51;
                                                }
                                                case "not-null": {
                                                    propertyType.notNull = this.reader.nextBoolean();
                                                    continue block51;
                                                }
                                                case "min": {
                                                    propertyType.min = this.parseAttributeValue(this.reader, propertyName + ".max", false);
                                                    continue block51;
                                                }
                                                case "max": {
                                                    propertyType.max = this.parseAttributeValue(this.reader, propertyName + ".max", false);
                                                    continue block51;
                                                }
                                                case "regexp": {
                                                    propertyType.regexp = this.reader.nextString();
                                                    continue block51;
                                                }
                                                case "default-value": {
                                                    propertyType.defaultValue = this.parseAttributeValue(this.reader, propertyName + ".defaultValue", false);
                                                    continue block51;
                                                }
                                            }
                                            this.reader.skipValue();
                                        }
                                        cls.properties.put(propertyName, propertyType);
                                        this.reader.endObject();
                                    }
                                    this.reader.endArray();
                                    continue block47;
                                }
                            }
                            this.reader.skipValue();
                        }
                        this.reader.endObject();
                        this.classes.put(cls.name, cls);
                    }
                    this.reader.endArray();
                    continue block45;
                }
            }
            this.reader.skipValue();
        }
        this.reader.endObject();
        for (String className : this.classes.keySet()) {
            this.createType(className);
        }
    }

    private void createIndexes() {
        for (Map<String, Object> parsedIndex : this.parsedIndexes) {
            parsedIndex.get("name");
            boolean unique = parsedIndex.get("type").toString().startsWith("UNIQUE");
            Map indexDefinition = (Map)parsedIndex.get("indexDefinition");
            String className = (String)indexDefinition.get("className");
            String keyType = (String)indexDefinition.get("keyType");
            if (!this.classes.containsKey(className) || this.excludeClasses.contains(className)) continue;
            String fieldName = (String)indexDefinition.get("field");
            Object[] properties = new String[]{fieldName};
            boolean nullValuesIgnored = (Boolean)indexDefinition.get("nullValuesIgnored");
            DocumentType type = this.database.getSchema().getType(className);
            if (!type.existsPolymorphicProperty(fieldName)) {
                if (keyType == null) {
                    this.logger.logLine(2, "- Skipped %s index creation on %s%s because the property is not defined and the key type is unknown", unique ? "UNIQUE" : "NOTUNIQUE", className, Arrays.toString(properties));
                    ++this.warnings;
                    continue;
                }
                type.createProperty(fieldName, Type.valueOf((String)keyType));
            }
            LSMTreeIndexAbstract.NULL_STRATEGY nullStrategy = (nullValuesIgnored = true) ? LSMTreeIndexAbstract.NULL_STRATEGY.SKIP : LSMTreeIndexAbstract.NULL_STRATEGY.ERROR;
            this.database.getSchema().getOrCreateTypeIndex(Schema.INDEX_TYPE.LSM_TREE, unique, className, (String[])properties, 262144, nullStrategy, null);
            this.logger.logLine(2, "- Created index %s on %s%s", unique ? "UNIQUE" : "NOTUNIQUE", className, Arrays.toString(properties));
        }
    }

    private void createType(String className) {
        VertexType t;
        OrientDBClass classInfo = this.classes.get(className);
        int type = className.equals("V") ? 1 : (className.equals("E") ? 2 : 0);
        if (!classInfo.superClasses.isEmpty()) {
            for (String c : classInfo.superClasses) {
                this.createType(c);
            }
            type = this.getClassType(classInfo.superClasses);
        }
        if (this.database.getSchema().existsType(className)) {
            return;
        }
        if (this.excludeClasses.contains(className)) {
            return;
        }
        int bucketsPerType = this.settings.getIntValue(GlobalConfiguration.TYPE_DEFAULT_BUCKETS.getKey(), GlobalConfiguration.TYPE_DEFAULT_BUCKETS.getValueAsInteger());
        switch (type) {
            case 1: {
                t = this.database.getSchema().createVertexType(className, bucketsPerType);
                break;
            }
            case 2: {
                t = this.database.getSchema().createEdgeType(className, bucketsPerType);
                this.edgeClasses.add(className);
                break;
            }
            default: {
                t = this.database.getSchema().createDocumentType(className, bucketsPerType);
            }
        }
        for (String string : classInfo.superClasses) {
            if (this.excludeClasses.contains(string)) continue;
            t.addSuperType(string);
        }
        for (Map.Entry entry : classInfo.properties.entrySet()) {
            OrientDBProperty orientdbProperty = (OrientDBProperty)entry.getValue();
            String orientdbType = switch (orientdbType = orientdbProperty.type) {
                case "EMBEDDEDLIST", "EMBEDDEDSET", "LINKLIST", "LINKSET" -> "LIST";
                case "EMBEDDEDMAP", "LINKMAP" -> "MAP";
            };
            try {
                Property property = t.createProperty((String)entry.getKey(), Type.valueOf((String)orientdbType), orientdbProperty.ofType);
                if (orientdbProperty.customFields != null) {
                    for (Map.Entry<String, Object> customEntry : orientdbProperty.customFields.entrySet()) {
                        property.setCustomValue(customEntry.getKey(), customEntry.getValue());
                    }
                }
                if (orientdbProperty.mandatory != null) {
                    property.setMandatory(orientdbProperty.mandatory.booleanValue());
                }
                if (orientdbProperty.readOnly != null) {
                    property.setReadonly(orientdbProperty.readOnly.booleanValue());
                }
                if (orientdbProperty.notNull != null) {
                    property.setNotNull(orientdbProperty.notNull.booleanValue());
                }
                if (orientdbProperty.min != null) {
                    property.setMin(orientdbProperty.min.toString());
                }
                if (orientdbProperty.max != null) {
                    property.setMax(orientdbProperty.max.toString());
                }
                if (orientdbProperty.regexp != null) {
                    property.setRegexp(orientdbProperty.regexp);
                }
                if (orientdbProperty.defaultValue == null) continue;
                property.setDefaultValue(orientdbProperty.defaultValue);
            }
            catch (Exception e) {
                this.logger.logLine(1, "- Unknown type '%s', ignoring creation of property in the schema for '%s.%s'", orientdbType, t.getName(), entry.getKey());
                ++this.warnings;
            }
        }
        this.logger.logLine(2, "- Created type '%s' which extends from %s with the following properties %s", className, classInfo.superClasses, classInfo.properties);
    }

    private int getClassType(List<String> list) {
        int type = 0;
        for (int i = 0; type == 0 && i < list.size(); ++i) {
            String su = list.get(i);
            if (su.equals("V")) {
                type = 1;
                break;
            }
            if (su.equals("E")) {
                type = 2;
                break;
            }
            OrientDBClass c = this.classes.get(su);
            if (c == null || c.superClasses.isEmpty()) continue;
            type = this.getClassType(c.superClasses);
        }
        return type;
    }

    private void parseClusters() throws IOException {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            this.reader.beginObject();
            String clusterName = null;
            int clusterId = -1;
            while (this.reader.hasNext()) {
                switch (this.reader.nextName()) {
                    case "name": {
                        clusterName = this.reader.nextString();
                        break;
                    }
                    case "id": {
                        clusterId = this.reader.nextInt();
                        break;
                    }
                    default: {
                        this.reader.skipValue();
                    }
                }
                if (clusterName == null || clusterId <= -1) continue;
                clusterName = null;
                clusterId = -1;
                this.skipUntilEndOfObject(this.reader, JsonToken.END_OBJECT);
                if (this.reader.peek() != JsonToken.BEGIN_OBJECT) break;
                this.reader.beginObject();
            }
            this.reader.endObject();
        }
        this.reader.endArray();
    }

    private void parseDatabaseInfo() throws IOException {
        this.reader.beginObject();
        switch (this.reader.nextName()) {
            case "name": {
                this.databaseName = this.reader.nextString();
                break;
            }
            default: {
                this.reader.skipValue();
            }
        }
        this.skipUntilEndOfObject(this.reader, JsonToken.END_OBJECT);
        this.reader.endObject();
    }

    private void skipUntilEndOfObject(JsonReader reader, JsonToken token) throws IOException {
        while (reader.hasNext()) {
            JsonToken t = reader.peek();
            reader.skipValue();
            if (t != token) continue;
            return;
        }
    }

    private void syntaxError(String s) {
        this.logger.errorLine("Syntax error: " + s, new Object[0]);
        this.error = true;
        this.printHelp();
    }

    private void printHeader() {
        this.logger.logLine(1, "ArcadeDB " + Constants.getVersion() + " - OrientDB Importer", new Object[0]);
    }

    private void printHelp() {
        this.logger.errorLine("Use:", new Object[0]);
        this.logger.errorLine("-d <database-path>: create a database from the OrientDB export", new Object[0]);
        this.logger.errorLine("-i <input-file>: path to the OrientDB export file. The default name is export.json.gz", new Object[0]);
        this.logger.errorLine("-s <security-file>: path to the security file generated from OrientDB users to use in ArcadeDB server", new Object[0]);
        this.logger.errorLine("-v <verbose-level>: 0 = error only, 1 = main steps, 2 = detailed steps, 3 = everything", new Object[0]);
    }

    private boolean checkForNullIndexes(Map<String, Object> properties, DocumentType type) {
        boolean valid = true;
        Collection indexes = type.getAllIndexes(true);
        for (Index index : indexes) {
            String indexedPropName;
            Object value;
            if (index.getNullStrategy() != LSMTreeIndexAbstract.NULL_STRATEGY.ERROR || (value = properties.get(indexedPropName = (String)index.getPropertyNames().getFirst())) != null) continue;
            ++this.skippedRecordBecauseNullKey;
            ++this.errors;
            if (this.settings.verboseLevel < 3 && this.skippedRecordBecauseNullKey == 100L) {
                this.logger.logLine(2, "- Skipped 100 records where indexed field is null and the index is not accepting NULLs. Not reporting further case to reduce the output", new Object[0]);
            } else if (this.settings.verboseLevel > 2 || this.skippedRecordBecauseNullKey < 100L) {
                this.logger.logLine(2, "- Skipped record %s because indexed field '%s' is null and the index is not accepting NULLs", properties, indexedPropName);
            }
            valid = false;
        }
        return valid;
    }

    private void incrementRecordByClass(String className) {
        Long recordsByClass = this.totalRecordByType.computeIfAbsent(className, k -> 0L);
        this.totalRecordByType.put(className, recordsByClass + 1L);
    }

    private static enum Phase {
        OFF,
        ANALYZE,
        CREATE_SCHEMA,
        CREATE_RECORDS,
        CREATE_EDGES;

    }

    private static class OrientDBClass {
        String name;
        List<String> superClasses = new ArrayList<String>();
        List<Integer> clusterIds = new ArrayList<Integer>();
        Map<String, OrientDBProperty> properties = new LinkedHashMap<String, OrientDBProperty>();

        private OrientDBClass() {
        }
    }

    private static class OrientDBProperty {
        String type;
        String ofType;
        Boolean readOnly;
        Boolean mandatory;
        Boolean notNull;
        Object defaultValue;
        Object min;
        Object max;
        String regexp;
        Map<String, Object> customFields;

        private OrientDBProperty() {
        }
    }
}

