/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.backup.format;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.LocalDatabase;
import com.arcadedb.engine.ComponentFile;
import com.arcadedb.integration.backup.BackupException;
import com.arcadedb.integration.backup.BackupSettings;
import com.arcadedb.integration.backup.format.AbstractBackupFormat;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.schema.LocalSchema;
import com.arcadedb.utility.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class FullBackupFormat
extends AbstractBackupFormat {
    public FullBackupFormat(DatabaseInternal database, BackupSettings settings, ConsoleLogger logger) {
        super(database, settings, logger);
    }

    @Override
    public void backupDatabase() throws Exception {
        File backupFile;
        this.settings.validateSettings();
        Object fileName = this.settings.file.startsWith("file://") ? this.settings.file.substring("file://".length()) : this.settings.file;
        if (this.settings.directory != null) {
            fileName = this.settings.directory + File.separator + (String)fileName;
        }
        if ((backupFile = new File((String)fileName)).exists() && !this.settings.overwriteFile) {
            throw new BackupException("The backup file '%s' already exist and '-o' setting is false".formatted(this.settings.file));
        }
        if (backupFile.getParentFile() != null && !backupFile.getParentFile().exists() && !backupFile.getParentFile().mkdirs()) {
            throw new BackupException("The backup file '%s' cannot be created".formatted(backupFile));
        }
        if (this.database.isTransactionActive() && this.database.getTransaction().hasChanges()) {
            throw new BackupException("Transaction in progress found");
        }
        this.logger.logLine(0, "Executing full backup of database to '%s'...", backupFile);
        this.encryptFile(backupFile, zipFile -> this.database.executeInReadLock(() -> {
            this.database.getPageManager().suspendFlushAndExecute((Database)this.database, () -> {
                long beginTime = System.currentTimeMillis();
                long databaseOrigSize = 0L;
                databaseOrigSize += this.compressFile(zipFile, ((LocalDatabase)this.database.getEmbedded()).getConfigurationFile());
                databaseOrigSize += this.compressFile(zipFile, ((LocalSchema)this.database.getSchema()).getConfigurationFile());
                List files = this.database.getFileManager().getFiles();
                for (ComponentFile file : new ArrayList(files)) {
                    if (file == null) continue;
                    databaseOrigSize += this.compressFile(zipFile, file.getOSFile());
                }
                zipFile.close();
                long elapsedInSecs = (System.currentTimeMillis() - beginTime) / 1000L;
                long databaseCompressedSize = backupFile.length();
                this.logger.logLine(0, "Full backup completed in %d seconds %s -> %s (%,d%% compressed)", elapsedInSecs, FileUtils.getSizeAsString((long)databaseOrigSize), FileUtils.getSizeAsString((long)databaseCompressedSize), databaseOrigSize > 0L ? (databaseOrigSize - databaseCompressedSize) * 100L / databaseOrigSize : 0L);
            });
            return null;
        }));
    }

    private long compressFile(ZipOutputStream zipFile, File inputFile) throws IOException {
        this.logger.log(2, "- File '%s'...", inputFile.getName());
        if (inputFile.exists()) {
            long origSize = inputFile.length();
            ZipEntry zipEntry = new ZipEntry(inputFile.getName());
            zipFile.putNextEntry(zipEntry);
            try (FileInputStream fileIn = new FileInputStream(inputFile);){
                fileIn.transferTo(zipFile);
            }
            zipFile.closeEntry();
            long compressedSize = zipEntry.getCompressedSize();
            this.logger.logLine(2, " %s -> %s (%,d%% compressed)", FileUtils.getSizeAsString((long)origSize), FileUtils.getSizeAsString((long)compressedSize), origSize > 0L ? (origSize - compressedSize) * 100L / origSize : 0L);
            return origSize;
        }
        this.logger.logLine(2, " not found", new Object[0]);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encryptFile(File backupFile, BackupCallback callback) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(backupFile);){
            ZipOutputStream zipFile;
            if (this.settings.encryptionKey != null) {
                byte[] salt = new byte[16];
                new SecureRandom().nextBytes(salt);
                fos.write(salt);
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
                PBEKeySpec spec = new PBEKeySpec(this.settings.encryptionKey.toCharArray(), salt, 65536, 256);
                SecretKey tmp = factory.generateSecret(spec);
                byte[] derivedKeyBytes = tmp.getEncoded();
                SecretKeySpec secretKey = new SecretKeySpec(derivedKeyBytes, this.settings.encryptionAlgorithm);
                Cipher cipher = Cipher.getInstance(this.settings.encryptionAlgorithm + "/CTR/NoPadding");
                byte[] iv = new byte[16];
                new SecureRandom().nextBytes(iv);
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(1, (Key)secretKey, ivSpec);
                fos.write(iv);
                CipherOutputStream cos = new CipherOutputStream(fos, cipher);
                zipFile = new ZipOutputStream((OutputStream)cos, StandardCharsets.UTF_8);
            } else {
                zipFile = new ZipOutputStream((OutputStream)fos, StandardCharsets.UTF_8);
            }
            zipFile.setLevel(9);
            try {
                callback.backup(zipFile);
            }
            finally {
                zipFile.close();
            }
        }
    }

    private static interface BackupCallback {
        public void backup(ZipOutputStream var1) throws Exception;
    }
}

