/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.backup;

import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BackupSettings {
    public String format = "full";
    public String databaseURL;
    public String directory;
    public String file;
    public boolean overwriteFile = false;
    public int verboseLevel = 2;
    public String encryptionAlgorithm = "AES";
    public String encryptionKey;
    public final Map<String, String> options = new HashMap<String, String>();
    public String databaseName;

    protected void parseParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; i += this.parseParameter(args[i].substring(1), i < args.length - 1 ? args[i + 1] : null)) {
            }
        }
        this.validateSettings();
    }

    public void validateSettings() {
        if (this.format == null) {
            throw new IllegalArgumentException("Missing backup format");
        }
        if (this.directory != null && this.file != null) {
            String f;
            String string = f = this.file.startsWith("file://") ? this.file.substring("file://".length()) : this.file;
            if (f.contains("..") || f.contains(File.separator)) {
                throw new IllegalArgumentException("Backup file cannot contain path change because the directory is specified");
            }
        }
        if (this.file == null && this.format.equals("full")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
            this.file = "%s-backup-%s.zip".formatted(this.databaseName, dateFormat.format(System.currentTimeMillis()));
        }
    }

    public int parseParameter(String name, String value) {
        String string = name;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"encryptionAlgorithm", "encryptionKey", "format", "dir", "f", "d", "o"}, (Object)string, n)) {
            case 0: {
                this.encryptionAlgorithm = value;
                break;
            }
            case 1: {
                this.encryptionKey = value;
                break;
            }
            case 2: {
                if (value == null) break;
                this.format = value.toLowerCase(Locale.ENGLISH);
                break;
            }
            case 3: {
                if (value == null) break;
                this.directory = value.endsWith(File.separator) ? value : value + File.separator;
                break;
            }
            case 4: {
                if (value == null) break;
                this.file = value;
                break;
            }
            case 5: {
                if (value == null) break;
                this.databaseURL = value;
                break;
            }
            case 6: {
                this.overwriteFile = true;
                return 1;
            }
            default: {
                this.options.put(name, value);
            }
        }
        return 2;
    }
}

