/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.Source;
import com.arcadedb.integration.importer.SourceSchema;
import java.io.IOException;

public interface FormatImporter {
    public void load(SourceSchema var1, AnalyzedEntity.ENTITY_TYPE var2, Parser var3, DatabaseInternal var4, ImporterContext var5, ImporterSettings var6) throws IOException;

    public SourceSchema analyze(AnalyzedEntity.ENTITY_TYPE var1, Parser var2, ImporterSettings var3, AnalyzedSchema var4) throws IOException;

    public String getFormat();

    default public void printProgress(ImporterSettings settings, ImporterContext context, Source source, Parser parser, ConsoleLogger logger) {
        if (settings.verboseLevel < 2) {
            return;
        }
        try {
            long deltaInSecs = (System.currentTimeMillis() - context.lastLapOn) / 1000L;
            if (deltaInSecs == 0L) {
                deltaInSecs = 1L;
            }
            if (source == null || source.compressed || source.totalSize < 0L) {
                logger.logLine(2, "- Parsed %,d (%,d/sec) %,d documents (%,d/sec) %,d vertices (%,d/sec) %,d edges (%,d/sec %,d skipped) %,d linked edges (%,d/sec %,d%%) updated documents %,d (%,d%%)", context.parsed.get(), (context.parsed.get() - context.lastParsed) / deltaInSecs, context.createdDocuments.get(), (context.createdDocuments.get() - context.lastDocuments) / deltaInSecs, context.createdVertices.get(), (context.createdVertices.get() - context.lastVertices) / deltaInSecs, context.createdEdges.get(), (context.createdEdges.get() - context.lastEdges) / deltaInSecs, context.skippedEdges.get(), context.linkedEdges.get(), (context.linkedEdges.get() - context.lastLinkedEdges) / deltaInSecs, context.createdEdges.get() > 0L ? (int)(context.linkedEdges.get() * 100L / context.createdEdges.get()) : 0, context.updatedDocuments.get(), context.documentsWithLinksToUpdate.get() > 0L ? (int)(context.updatedDocuments.get() * 100L / context.documentsWithLinksToUpdate.get()) : 0);
            } else {
                int progressPerc = (int)(parser.getPosition() * 100L / source.totalSize);
                logger.logLine(2, "Parsed %,d (%,d/sec %,d%%) %,d records (%,d/sec) %,d vertices (%,d/sec) %,d edges (%,d/sec %,d skipped) %,d linked edges (%,d/sec %,d%%) updated documents %,d (%,d%%)", context.parsed.get(), (context.parsed.get() - context.lastParsed) / deltaInSecs, progressPerc, context.createdDocuments.get(), (context.createdDocuments.get() - context.lastDocuments) / deltaInSecs, context.createdVertices.get(), (context.createdVertices.get() - context.lastVertices) / deltaInSecs, context.createdEdges.get(), (context.createdEdges.get() - context.lastEdges) / deltaInSecs, context.skippedEdges.get(), context.linkedEdges.get(), (context.linkedEdges.get() - context.lastLinkedEdges) / deltaInSecs, context.createdEdges.get() > 0L ? (int)(context.linkedEdges.get() * 100L / context.createdEdges.get()) : 0, context.updatedDocuments.get(), context.documentsWithLinksToUpdate.get() > 0L ? (int)(context.updatedDocuments.get() * 100L / context.documentsWithLinksToUpdate.get()) : 0);
            }
            context.lastLapOn = System.currentTimeMillis();
            context.lastParsed = context.parsed.get();
            context.lastDocuments = context.createdDocuments.get();
            context.lastVertices = context.createdVertices.get();
            context.lastEdges = context.createdEdges.get();
            context.lastLinkedEdges = context.linkedEdges.get();
        }
        catch (Exception e) {
            logger.errorLine("Error on print statistics: " + e.getMessage(), new Object[0]);
        }
    }
}

