/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.schema.Type;
import java.util.HashSet;
import java.util.Set;

public class AnalyzedProperty {
    private final String name;
    private final long maxValueSampling;
    private Type type;
    private final int index;
    private String lastContent;
    private final Set<String> contents = new HashSet<String>();
    private boolean candidateForInteger = true;
    private boolean candidateForDecimal = true;
    private boolean collectingSamples = true;

    public AnalyzedProperty(String name, Type type, long maxValueSampling, int index) {
        this.name = name;
        this.type = type;
        this.maxValueSampling = maxValueSampling;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void endParsing() {
        if (this.lastContent != null) {
            if (this.candidateForInteger) {
                this.type = Type.LONG;
            } else if (this.candidateForDecimal) {
                this.type = Type.DOUBLE;
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setLastContent(String lastContent) {
        if (!this.collectingSamples) {
            return;
        }
        if (lastContent != null) {
            if (lastContent.length() > 100) {
                this.collectingSamples = false;
                this.contents.clear();
                return;
            }
            this.lastContent = lastContent;
            if ((long)this.contents.size() > this.maxValueSampling) {
                this.collectingSamples = false;
                this.contents.clear();
                return;
            }
            this.contents.add(lastContent);
            if (!lastContent.isEmpty()) {
                if (this.candidateForInteger) {
                    try {
                        Long.parseLong(lastContent);
                    }
                    catch (NumberFormatException e) {
                        this.candidateForInteger = false;
                    }
                }
                if (this.candidateForDecimal) {
                    try {
                        Double.parseDouble(lastContent);
                    }
                    catch (NumberFormatException e) {
                        this.candidateForDecimal = false;
                    }
                }
            }
        }
    }

    public Set<String> getContents() {
        return this.contents;
    }

    public boolean isCollectingSamples() {
        return this.collectingSamples;
    }

    public String toString() {
        return this.name;
    }
}

