/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.integration.importer.AnalyzedProperty;
import com.arcadedb.schema.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AnalyzedEntity {
    private final String name;
    private final ENTITY_TYPE type;
    private final Map<String, AnalyzedProperty> properties;
    private long totalRowLength = 0L;
    private long analyzedRows = 0L;
    private final long maxValueSampling;

    public AnalyzedEntity(String name, ENTITY_TYPE type, long maxValueSampling) {
        this.name = name;
        this.type = type;
        this.properties = new LinkedHashMap<String, AnalyzedProperty>();
        this.maxValueSampling = maxValueSampling;
    }

    public Collection<AnalyzedProperty> getProperties() {
        return this.properties.values();
    }

    public AnalyzedProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public void getOrCreateProperty(String name, String content) {
        AnalyzedProperty property = this.properties.get(name);
        if (property == null) {
            property = new AnalyzedProperty(name, Type.STRING, this.maxValueSampling, this.properties.size());
            this.properties.put(property.getName(), property);
        }
        property.setLastContent(content);
    }

    public int getAverageRowLength() {
        return (int)(this.totalRowLength / this.analyzedRows);
    }

    public void setRowSize(String[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (row[i] != null) {
                this.totalRowLength += (long)row[i].length();
            }
            ++this.totalRowLength;
        }
        ++this.totalRowLength;
        ++this.analyzedRows;
    }

    public String getName() {
        return this.name;
    }

    public ENTITY_TYPE getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyzedEntity that = (AnalyzedEntity)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }

    public static enum ENTITY_TYPE {
        DATABASE,
        DOCUMENT,
        VERTEX,
        EDGE;

    }
}

