/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedProperty;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnalyzedSchema {
    private final Map<String, AnalyzedEntity> entities = new LinkedHashMap<String, AnalyzedEntity>();
    private final long maxValueSampling;

    public AnalyzedSchema(long maxValueSampling) {
        this.maxValueSampling = maxValueSampling;
    }

    public AnalyzedEntity getOrCreateEntity(String entityName, AnalyzedEntity.ENTITY_TYPE entityType) {
        AnalyzedEntity entity = this.entities.get(entityName);
        if (entity == null) {
            entity = new AnalyzedEntity(entityName, entityType, this.maxValueSampling);
            this.entities.put(entityName, entity);
        }
        return entity;
    }

    public void endParsing() {
        for (AnalyzedEntity entity : this.entities.values()) {
            for (AnalyzedProperty property : entity.getProperties()) {
                property.endParsing();
            }
        }
    }

    public Collection<AnalyzedEntity> getEntities() {
        return this.entities.values();
    }

    public AnalyzedEntity getEntity(String name) {
        return this.entities.get(name);
    }
}

