/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.exporter.format;

import com.arcadedb.Constants;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Document;
import com.arcadedb.database.Record;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.Vertex;
import com.arcadedb.integration.exporter.ExportException;
import com.arcadedb.integration.exporter.ExporterContext;
import com.arcadedb.integration.exporter.ExporterSettings;
import com.arcadedb.integration.exporter.format.AbstractExporterFormat;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.log.LogManager;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.LocalEdgeType;
import com.arcadedb.schema.LocalSchema;
import com.arcadedb.schema.LocalVertexType;
import com.arcadedb.serializer.JsonGraphSerializer;
import com.arcadedb.serializer.json.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;

public class JsonlExporterFormat
extends AbstractExporterFormat {
    public static final String NAME = "jsonl";
    protected final JSONObject sharedJson = new JSONObject();
    private OutputStreamWriter writer;
    private static final int VERSION = 1;

    public JsonlExporterFormat(DatabaseInternal database, ExporterSettings settings, ExporterContext context, ConsoleLogger logger) {
        super(database, settings, context, logger);
    }

    @Override
    public void exportDatabase() throws Exception {
        File file = new File(this.settings.file);
        if (file.exists() && !this.settings.overwriteFile) {
            throw new ExportException("The export file '%s' already exist and '-o' setting is false".formatted(this.settings.file));
        }
        if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ExportException("The export file '%s' cannot be created".formatted(this.settings.file));
        }
        if (this.database.isTransactionActive()) {
            this.database.getTransaction().rollback();
        }
        this.logger.logLine(0, "Exporting database to '%s'...", this.settings.file);
        File exportFile = this.settings.file.startsWith("file://") ? new File(this.settings.file.substring("file://".length())) : new File(this.settings.file);
        if (!exportFile.getParentFile().exists()) {
            exportFile.getParentFile().mkdirs();
        }
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(exportFile)), DatabaseFactory.getDefaultCharset());){
            this.writer = fileWriter;
            this.writeJsonLine("info", new JSONObject().put("description", "ArcadeDB Database Export").put("exporterVersion", (Number)1).put("dbVersion", Constants.getRawVersion()).put("dbBranch", Constants.getBranch()).put("dbBuild", Constants.getBuildNumber()).put("dbTimestamp", Constants.getTimestamp()));
            long now = System.currentTimeMillis();
            this.writeJsonLine("db", new JSONObject().put("name", this.database.getName()).put("executedOn", dateFormat.format(now)).put("executedOnTimestamp", (Number)now));
            this.writeJsonLine("schema", ((LocalSchema)this.database.getSchema()).toJSON());
            ArrayList<String> vertexTypes = new ArrayList<String>();
            ArrayList<String> edgeTypes = new ArrayList<String>();
            ArrayList<String> documentTypes = new ArrayList<String>();
            for (DocumentType type : this.database.getSchema().getTypes()) {
                String typeName = type.getName();
                if (this.settings.includeTypes != null && !this.settings.includeTypes.contains(typeName) || this.settings.excludeTypes != null && this.settings.excludeTypes.contains(typeName)) continue;
                if (type instanceof LocalVertexType) {
                    vertexTypes.add(typeName);
                    continue;
                }
                if (type instanceof LocalEdgeType) {
                    edgeTypes.add(typeName);
                    continue;
                }
                documentTypes.add(typeName);
            }
            JSONObject recordJson = new JSONObject();
            JsonGraphSerializer graphSerializer = JsonGraphSerializer.createJsonGraphSerializer().setSharedJson(recordJson).setIncludeMetadata(false).setExpandVertexEdges(true);
            this.exportVertices(vertexTypes, graphSerializer);
            this.exportDocuments(documentTypes, graphSerializer);
            this.exportEdges(edgeTypes, graphSerializer);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    private void exportVertices(List<String> vertexTypes, JsonGraphSerializer graphSerializer) throws IOException {
        for (String type : vertexTypes) {
            Iterator cursor = this.database.iterateType(type, false);
            while (cursor.hasNext()) {
                Vertex record = null;
                try {
                    record = ((Record)cursor.next()).asVertex(true);
                    if (this.settings.includeRecords != null && !this.settings.includeRecords.contains(record.getIdentity().toString())) continue;
                    this.writeJsonLine("v", graphSerializer.serializeGraphElement((Document)record));
                    this.context.vertices.incrementAndGet();
                }
                catch (Exception e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Error on exporting vertex %s", (Throwable)e, (Object)(record != null ? record.getIdentity() : null));
                }
            }
        }
    }

    private void exportEdges(List<String> edgeTypes, JsonGraphSerializer graphSerializer) throws IOException {
        for (String type : edgeTypes) {
            Iterator cursor = this.database.iterateType(type, false);
            while (cursor.hasNext()) {
                Edge record = null;
                try {
                    record = ((Record)cursor.next()).asEdge(true);
                    if (this.settings.includeRecords != null && !this.settings.includeRecords.contains(record.getIdentity().toString())) continue;
                    this.writeJsonLine("e", graphSerializer.serializeGraphElement((Document)record));
                    this.context.edges.incrementAndGet();
                }
                catch (Exception e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Error on exporting vertex %s", (Throwable)e, (Object)(record != null ? record.getIdentity() : null));
                }
            }
        }
    }

    private void exportDocuments(List<String> documentTypes, JsonGraphSerializer graphSerializer) throws IOException {
        for (String type : documentTypes) {
            Iterator cursor = this.database.iterateType(type, false);
            while (cursor.hasNext()) {
                Document record = null;
                try {
                    record = ((Record)cursor.next()).asDocument(true);
                    if (this.settings.includeRecords != null && !this.settings.includeRecords.contains(record.getIdentity().toString())) continue;
                    this.writeJsonLine("d", graphSerializer.serializeGraphElement(record));
                    this.context.documents.incrementAndGet();
                }
                catch (Exception e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Error on exporting vertex %s", (Throwable)e, (Object)(record != null ? record.getIdentity() : null));
                }
            }
        }
    }

    protected void writeJsonLine(String type, JSONObject json) throws IOException {
        this.writer.write(this.sharedJson.put("t", type).put("c", (Object)json).toString() + "\n");
        this.sharedJson.clear();
    }
}

