/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.ir;

import com.apollographql.apollo.annotations.ApolloInternal;
import com.apollographql.apollo.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo.ast.GQLListType;
import com.apollographql.apollo.ast.GQLNamedType;
import com.apollographql.apollo.ast.GQLNonNullType;
import com.apollographql.apollo.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo.ast.GQLType;
import com.apollographql.apollo.ast.GQLTypeDefinition;
import com.apollographql.apollo.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo.ast.Schema;
import com.apollographql.apollo.compiler.ir.IrCatchTo;
import com.apollographql.apollo.compiler.ir.IrEnumType;
import com.apollographql.apollo.compiler.ir.IrInputObjectType;
import com.apollographql.apollo.compiler.ir.IrListType;
import com.apollographql.apollo.compiler.ir.IrModelType;
import com.apollographql.apollo.compiler.ir.IrNamedType;
import com.apollographql.apollo.compiler.ir.IrObjectType;
import com.apollographql.apollo.compiler.ir.IrScalarType;
import com.apollographql.apollo.compiler.ir.IrType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\tH\u0000\u001a\u0014\u0010\f\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\f\u001a\u00020\tH\u0007\u001a\u0014\u0010\r\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0007\u001a\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"MODEL_FRAGMENT_DATA", "", "MODEL_FRAGMENT_INTERFACE", "MODEL_OPERATION_DATA", "MODEL_UNKNOWN", "catchTo", "Lcom/apollographql/apollo/compiler/ir/IrType;", "Lcom/apollographql/apollo/compiler/ir/IrCatchTo;", "isComposite", "", "Lcom/apollographql/apollo/compiler/ir/IrNamedType;", "maybeError", "nullable", "optional", "replacePlaceholder", "newPath", "toIr", "Lcom/apollographql/apollo/ast/GQLType;", "schema", "Lcom/apollographql/apollo/ast/Schema;", "apollo-compiler"})
public final class IrTypeKt {
    @NotNull
    public static final String MODEL_OPERATION_DATA = "operationData";
    @NotNull
    public static final String MODEL_FRAGMENT_DATA = "fragmentData";
    @NotNull
    public static final String MODEL_FRAGMENT_INTERFACE = "fragmentInterface";
    @NotNull
    public static final String MODEL_UNKNOWN = "?";

    @ApolloInternal
    @NotNull
    public static final IrType nullable(@NotNull IrType $this$nullable, boolean nullable) {
        Intrinsics.checkNotNullParameter((Object)$this$nullable, (String)"<this>");
        return IrType.copyWith$default($this$nullable, false, nullable, false, null, 13, null);
    }

    @ApolloInternal
    @NotNull
    public static final IrType optional(@NotNull IrType $this$optional, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)$this$optional, (String)"<this>");
        return IrType.copyWith$default($this$optional, false, false, optional, null, 11, null);
    }

    @NotNull
    public static final IrType catchTo(@NotNull IrType $this$catchTo, @NotNull IrCatchTo catchTo) {
        Intrinsics.checkNotNullParameter((Object)$this$catchTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)catchTo), (String)"catchTo");
        return IrType.copyWith$default($this$catchTo, false, false, false, catchTo, 7, null);
    }

    @NotNull
    public static final IrType maybeError(@NotNull IrType $this$maybeError, boolean maybeError) {
        Intrinsics.checkNotNullParameter((Object)$this$maybeError, (String)"<this>");
        return IrType.copyWith$default($this$maybeError, maybeError, false, false, null, 14, null);
    }

    @NotNull
    public static final IrType replacePlaceholder(@NotNull IrType $this$replacePlaceholder, @NotNull String newPath) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$replacePlaceholder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        IrType irType2 = $this$replacePlaceholder;
        if (irType2 instanceof IrListType) {
            irType = IrListType.copy$default((IrListType)$this$replacePlaceholder, IrTypeKt.replacePlaceholder(((IrListType)$this$replacePlaceholder).getOfType(), newPath), false, false, null, false, 30, null);
        } else if (irType2 instanceof IrModelType) {
            irType = IrModelType.copy$default((IrModelType)$this$replacePlaceholder, newPath, false, false, null, false, 30, null);
        } else {
            throw new IllegalStateException("Not a compound type?".toString());
        }
        return irType;
    }

    @NotNull
    public static final IrType toIr(@NotNull GQLType $this$toIr, @NotNull Schema schema) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)$this$toIr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        GQLType gQLType = $this$toIr;
        if (gQLType instanceof GQLNonNullType) {
            irType = IrType.copyWith$default(IrTypeKt.toIr(((GQLNonNullType)$this$toIr).getType(), schema), false, false, false, null, 12, null);
        } else if (gQLType instanceof GQLListType) {
            irType = new IrListType(IrTypeKt.toIr(((GQLListType)$this$toIr).getType(), schema), true, false, null, schema.getErrorAware(), 12, null);
        } else if (gQLType instanceof GQLNamedType) {
            IrNamedType irNamedType;
            GQLTypeDefinition gQLTypeDefinition = schema.typeDefinition(((GQLNamedType)$this$toIr).getName());
            if (gQLTypeDefinition instanceof GQLScalarTypeDefinition) {
                irNamedType = new IrScalarType(((GQLNamedType)$this$toIr).getName(), true, false, null, schema.getErrorAware(), 12, null);
            } else if (gQLTypeDefinition instanceof GQLEnumTypeDefinition) {
                irNamedType = new IrEnumType(((GQLNamedType)$this$toIr).getName(), true, false, null, schema.getErrorAware(), 12, null);
            } else if (gQLTypeDefinition instanceof GQLInputObjectTypeDefinition) {
                irNamedType = new IrInputObjectType(((GQLNamedType)$this$toIr).getName(), true, false, null, schema.getErrorAware(), 12, null);
            } else if (gQLTypeDefinition instanceof GQLObjectTypeDefinition) {
                irNamedType = new IrModelType(MODEL_UNKNOWN, true, false, null, schema.getErrorAware(), 12, null);
            } else if (gQLTypeDefinition instanceof GQLInterfaceTypeDefinition) {
                irNamedType = new IrModelType(MODEL_UNKNOWN, true, false, null, schema.getErrorAware(), 12, null);
            } else if (gQLTypeDefinition instanceof GQLUnionTypeDefinition) {
                irNamedType = new IrModelType(MODEL_UNKNOWN, true, false, null, schema.getErrorAware(), 12, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            irType = irNamedType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irType;
    }

    public static final boolean isComposite(@NotNull IrNamedType $this$isComposite) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isComposite, (String)"<this>");
        IrNamedType irNamedType = $this$isComposite;
        if (irNamedType instanceof IrScalarType) {
            bl = false;
        } else if (irNamedType instanceof IrEnumType) {
            bl = false;
        } else if (irNamedType instanceof IrInputObjectType) {
            bl = true;
        } else if (irNamedType instanceof IrModelType) {
            bl = true;
        } else if (irNamedType instanceof IrObjectType) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

