// File generated from our OpenAPI spec by Stainless.

package com.anthropic.models.beta.messages

import com.anthropic.core.ExcludeMissing
import com.anthropic.core.JsonField
import com.anthropic.core.JsonMissing
import com.anthropic.core.JsonValue
import com.anthropic.core.checkKnown
import com.anthropic.core.checkRequired
import com.anthropic.core.toImmutable
import com.anthropic.errors.AnthropicInvalidDataException
import com.anthropic.models.messages.Model
import com.fasterxml.jackson.annotation.JsonAnyGetter
import com.fasterxml.jackson.annotation.JsonAnySetter
import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonProperty
import java.util.Collections
import java.util.Objects
import java.util.Optional
import kotlin.jvm.optionals.getOrNull

class BetaMessage
private constructor(
    private val id: JsonField<String>,
    private val content: JsonField<List<BetaContentBlock>>,
    private val model: JsonField<Model>,
    private val role: JsonValue,
    private val stopReason: JsonField<BetaStopReason>,
    private val stopSequence: JsonField<String>,
    private val type: JsonValue,
    private val usage: JsonField<BetaUsage>,
    private val additionalProperties: MutableMap<String, JsonValue>,
) {

    @JsonCreator
    private constructor(
        @JsonProperty("id") @ExcludeMissing id: JsonField<String> = JsonMissing.of(),
        @JsonProperty("content")
        @ExcludeMissing
        content: JsonField<List<BetaContentBlock>> = JsonMissing.of(),
        @JsonProperty("model") @ExcludeMissing model: JsonField<Model> = JsonMissing.of(),
        @JsonProperty("role") @ExcludeMissing role: JsonValue = JsonMissing.of(),
        @JsonProperty("stop_reason")
        @ExcludeMissing
        stopReason: JsonField<BetaStopReason> = JsonMissing.of(),
        @JsonProperty("stop_sequence")
        @ExcludeMissing
        stopSequence: JsonField<String> = JsonMissing.of(),
        @JsonProperty("type") @ExcludeMissing type: JsonValue = JsonMissing.of(),
        @JsonProperty("usage") @ExcludeMissing usage: JsonField<BetaUsage> = JsonMissing.of(),
    ) : this(id, content, model, role, stopReason, stopSequence, type, usage, mutableMapOf())

    fun toParam(): BetaMessageParam =
        BetaMessageParam.builder()
            .content(
                _content().map {
                    BetaMessageParam.Content.ofBetaContentBlockParams(it.map { it.toParam() })
                }
            )
            .role(_role())
            .build()

    /**
     * Unique object identifier.
     *
     * The format and length of IDs may change over time.
     *
     * @throws AnthropicInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun id(): String = id.getRequired("id")

    /**
     * Content generated by the model.
     *
     * This is an array of content blocks, each of which has a `type` that determines its shape.
     *
     * Example:
     * ```json
     * [{ "type": "text", "text": "Hi, I'm Claude." }]
     * ```
     *
     * If the request input `messages` ended with an `assistant` turn, then the response `content`
     * will continue directly from that last turn. You can use this to constrain the model's output.
     *
     * For example, if the input `messages` were:
     * ```json
     * [
     *   {
     *     "role": "user",
     *     "content": "What's the Greek name for Sun? (A) Sol (B) Helios (C) Sun"
     *   },
     *   { "role": "assistant", "content": "The best answer is (" }
     * ]
     * ```
     *
     * Then the response `content` might be:
     * ```json
     * [{ "type": "text", "text": "B)" }]
     * ```
     *
     * @throws AnthropicInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun content(): List<BetaContentBlock> = content.getRequired("content")

    /**
     * The model that will complete your prompt.\n\nSee
     * [models](https://docs.anthropic.com/en/docs/models-overview) for additional details and
     * options.
     *
     * @throws AnthropicInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun model(): Model = model.getRequired("model")

    /**
     * Conversational role of the generated message.
     *
     * This will always be `"assistant"`.
     *
     * Expected to always return the following:
     * ```java
     * JsonValue.from("assistant")
     * ```
     *
     * However, this method can be useful for debugging and logging (e.g. if the server responded
     * with an unexpected value).
     */
    @JsonProperty("role") @ExcludeMissing fun _role(): JsonValue = role

    /**
     * The reason that we stopped.
     *
     * This may be one the following values:
     * - `"end_turn"`: the model reached a natural stopping point
     * - `"max_tokens"`: we exceeded the requested `max_tokens` or the model's maximum
     * - `"stop_sequence"`: one of your provided custom `stop_sequences` was generated
     * - `"tool_use"`: the model invoked one or more tools
     *
     * In non-streaming mode this value is always non-null. In streaming mode, it is null in the
     * `message_start` event and non-null otherwise.
     *
     * @throws AnthropicInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun stopReason(): Optional<BetaStopReason> = stopReason.getOptional("stop_reason")

    /**
     * Which custom stop sequence was generated, if any.
     *
     * This value will be a non-null string if one of your custom stop sequences was generated.
     *
     * @throws AnthropicInvalidDataException if the JSON field has an unexpected type (e.g. if the
     *   server responded with an unexpected value).
     */
    fun stopSequence(): Optional<String> = stopSequence.getOptional("stop_sequence")

    /**
     * Object type.
     *
     * For Messages, this is always `"message"`.
     *
     * Expected to always return the following:
     * ```java
     * JsonValue.from("message")
     * ```
     *
     * However, this method can be useful for debugging and logging (e.g. if the server responded
     * with an unexpected value).
     */
    @JsonProperty("type") @ExcludeMissing fun _type(): JsonValue = type

    /**
     * Billing and rate-limit usage.
     *
     * Anthropic's API bills and rate-limits by token counts, as tokens represent the underlying
     * cost to our systems.
     *
     * Under the hood, the API transforms requests into a format suitable for the model. The model's
     * output then goes through a parsing stage before becoming an API response. As a result, the
     * token counts in `usage` will not match one-to-one with the exact visible content of an API
     * request or response.
     *
     * For example, `output_tokens` will be non-zero, even for an empty string response from Claude.
     *
     * Total input tokens in a request is the summation of `input_tokens`,
     * `cache_creation_input_tokens`, and `cache_read_input_tokens`.
     *
     * @throws AnthropicInvalidDataException if the JSON field has an unexpected type or is
     *   unexpectedly missing or null (e.g. if the server responded with an unexpected value).
     */
    fun usage(): BetaUsage = usage.getRequired("usage")

    /**
     * Returns the raw JSON value of [id].
     *
     * Unlike [id], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("id") @ExcludeMissing fun _id(): JsonField<String> = id

    /**
     * Returns the raw JSON value of [content].
     *
     * Unlike [content], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("content")
    @ExcludeMissing
    fun _content(): JsonField<List<BetaContentBlock>> = content

    /**
     * Returns the raw JSON value of [model].
     *
     * Unlike [model], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("model") @ExcludeMissing fun _model(): JsonField<Model> = model

    /**
     * Returns the raw JSON value of [stopReason].
     *
     * Unlike [stopReason], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("stop_reason")
    @ExcludeMissing
    fun _stopReason(): JsonField<BetaStopReason> = stopReason

    /**
     * Returns the raw JSON value of [stopSequence].
     *
     * Unlike [stopSequence], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("stop_sequence")
    @ExcludeMissing
    fun _stopSequence(): JsonField<String> = stopSequence

    /**
     * Returns the raw JSON value of [usage].
     *
     * Unlike [usage], this method doesn't throw if the JSON field has an unexpected type.
     */
    @JsonProperty("usage") @ExcludeMissing fun _usage(): JsonField<BetaUsage> = usage

    @JsonAnySetter
    private fun putAdditionalProperty(key: String, value: JsonValue) {
        additionalProperties.put(key, value)
    }

    @JsonAnyGetter
    @ExcludeMissing
    fun _additionalProperties(): Map<String, JsonValue> =
        Collections.unmodifiableMap(additionalProperties)

    fun toBuilder() = Builder().from(this)

    companion object {

        /**
         * Returns a mutable builder for constructing an instance of [BetaMessage].
         *
         * The following fields are required:
         * ```java
         * .id()
         * .content()
         * .model()
         * .stopReason()
         * .stopSequence()
         * .usage()
         * ```
         */
        @JvmStatic fun builder() = Builder()
    }

    /** A builder for [BetaMessage]. */
    class Builder internal constructor() {

        private var id: JsonField<String>? = null
        private var content: JsonField<MutableList<BetaContentBlock>>? = null
        private var model: JsonField<Model>? = null
        private var role: JsonValue = JsonValue.from("assistant")
        private var stopReason: JsonField<BetaStopReason>? = null
        private var stopSequence: JsonField<String>? = null
        private var type: JsonValue = JsonValue.from("message")
        private var usage: JsonField<BetaUsage>? = null
        private var additionalProperties: MutableMap<String, JsonValue> = mutableMapOf()

        @JvmSynthetic
        internal fun from(betaMessage: BetaMessage) = apply {
            id = betaMessage.id
            content = betaMessage.content.map { it.toMutableList() }
            model = betaMessage.model
            role = betaMessage.role
            stopReason = betaMessage.stopReason
            stopSequence = betaMessage.stopSequence
            type = betaMessage.type
            usage = betaMessage.usage
            additionalProperties = betaMessage.additionalProperties.toMutableMap()
        }

        /**
         * Unique object identifier.
         *
         * The format and length of IDs may change over time.
         */
        fun id(id: String) = id(JsonField.of(id))

        /**
         * Sets [Builder.id] to an arbitrary JSON value.
         *
         * You should usually call [Builder.id] with a well-typed [String] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun id(id: JsonField<String>) = apply { this.id = id }

        /**
         * Content generated by the model.
         *
         * This is an array of content blocks, each of which has a `type` that determines its shape.
         *
         * Example:
         * ```json
         * [{ "type": "text", "text": "Hi, I'm Claude." }]
         * ```
         *
         * If the request input `messages` ended with an `assistant` turn, then the response
         * `content` will continue directly from that last turn. You can use this to constrain the
         * model's output.
         *
         * For example, if the input `messages` were:
         * ```json
         * [
         *   {
         *     "role": "user",
         *     "content": "What's the Greek name for Sun? (A) Sol (B) Helios (C) Sun"
         *   },
         *   { "role": "assistant", "content": "The best answer is (" }
         * ]
         * ```
         *
         * Then the response `content` might be:
         * ```json
         * [{ "type": "text", "text": "B)" }]
         * ```
         */
        fun content(content: List<BetaContentBlock>) = content(JsonField.of(content))

        /**
         * Sets [Builder.content] to an arbitrary JSON value.
         *
         * You should usually call [Builder.content] with a well-typed `List<BetaContentBlock>`
         * value instead. This method is primarily for setting the field to an undocumented or not
         * yet supported value.
         */
        fun content(content: JsonField<List<BetaContentBlock>>) = apply {
            this.content = content.map { it.toMutableList() }
        }

        /**
         * Adds a single [BetaContentBlock] to [Builder.content].
         *
         * @throws IllegalStateException if the field was previously set to a non-list.
         */
        fun addContent(content: BetaContentBlock) = apply {
            this.content =
                (this.content ?: JsonField.of(mutableListOf())).also {
                    checkKnown("content", it).add(content)
                }
        }

        /** Alias for calling [addContent] with `BetaContentBlock.ofText(text)`. */
        fun addContent(text: BetaTextBlock) = addContent(BetaContentBlock.ofText(text))

        /** Alias for calling [addContent] with `BetaContentBlock.ofToolUse(toolUse)`. */
        fun addContent(toolUse: BetaToolUseBlock) = addContent(BetaContentBlock.ofToolUse(toolUse))

        /**
         * Alias for calling [addContent] with `BetaContentBlock.ofServerToolUse(serverToolUse)`.
         */
        fun addContent(serverToolUse: BetaServerToolUseBlock) =
            addContent(BetaContentBlock.ofServerToolUse(serverToolUse))

        /**
         * Alias for calling [addContent] with
         * `BetaContentBlock.ofWebSearchToolResult(webSearchToolResult)`.
         */
        fun addContent(webSearchToolResult: BetaWebSearchToolResultBlock) =
            addContent(BetaContentBlock.ofWebSearchToolResult(webSearchToolResult))

        /** Alias for calling [addContent] with `BetaContentBlock.ofThinking(thinking)`. */
        fun addContent(thinking: BetaThinkingBlock) =
            addContent(BetaContentBlock.ofThinking(thinking))

        /**
         * Alias for calling [addContent] with
         * `BetaContentBlock.ofRedactedThinking(redactedThinking)`.
         */
        fun addContent(redactedThinking: BetaRedactedThinkingBlock) =
            addContent(BetaContentBlock.ofRedactedThinking(redactedThinking))

        /**
         * Alias for calling [addContent] with the following:
         * ```java
         * BetaRedactedThinkingBlock.builder()
         *     .data(data)
         *     .build()
         * ```
         */
        fun addRedactedThinkingContent(data: String) =
            addContent(BetaRedactedThinkingBlock.builder().data(data).build())

        /**
         * The model that will complete your prompt.\n\nSee
         * [models](https://docs.anthropic.com/en/docs/models-overview) for additional details and
         * options.
         */
        fun model(model: Model) = model(JsonField.of(model))

        /**
         * Sets [Builder.model] to an arbitrary JSON value.
         *
         * You should usually call [Builder.model] with a well-typed [Model] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun model(model: JsonField<Model>) = apply { this.model = model }

        /**
         * Sets [model] to an arbitrary [String].
         *
         * You should usually call [model] with a well-typed [Model] constant instead. This method
         * is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun model(value: String) = model(Model.of(value))

        /**
         * Sets the field to an arbitrary JSON value.
         *
         * It is usually unnecessary to call this method because the field defaults to the
         * following:
         * ```java
         * JsonValue.from("assistant")
         * ```
         *
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun role(role: JsonValue) = apply { this.role = role }

        /**
         * The reason that we stopped.
         *
         * This may be one the following values:
         * - `"end_turn"`: the model reached a natural stopping point
         * - `"max_tokens"`: we exceeded the requested `max_tokens` or the model's maximum
         * - `"stop_sequence"`: one of your provided custom `stop_sequences` was generated
         * - `"tool_use"`: the model invoked one or more tools
         *
         * In non-streaming mode this value is always non-null. In streaming mode, it is null in the
         * `message_start` event and non-null otherwise.
         */
        fun stopReason(stopReason: BetaStopReason?) = stopReason(JsonField.ofNullable(stopReason))

        /** Alias for calling [Builder.stopReason] with `stopReason.orElse(null)`. */
        fun stopReason(stopReason: Optional<BetaStopReason>) = stopReason(stopReason.getOrNull())

        /**
         * Sets [Builder.stopReason] to an arbitrary JSON value.
         *
         * You should usually call [Builder.stopReason] with a well-typed [BetaStopReason] value
         * instead. This method is primarily for setting the field to an undocumented or not yet
         * supported value.
         */
        fun stopReason(stopReason: JsonField<BetaStopReason>) = apply {
            this.stopReason = stopReason
        }

        /**
         * Which custom stop sequence was generated, if any.
         *
         * This value will be a non-null string if one of your custom stop sequences was generated.
         */
        fun stopSequence(stopSequence: String?) = stopSequence(JsonField.ofNullable(stopSequence))

        /** Alias for calling [Builder.stopSequence] with `stopSequence.orElse(null)`. */
        fun stopSequence(stopSequence: Optional<String>) = stopSequence(stopSequence.getOrNull())

        /**
         * Sets [Builder.stopSequence] to an arbitrary JSON value.
         *
         * You should usually call [Builder.stopSequence] with a well-typed [String] value instead.
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun stopSequence(stopSequence: JsonField<String>) = apply {
            this.stopSequence = stopSequence
        }

        /**
         * Sets the field to an arbitrary JSON value.
         *
         * It is usually unnecessary to call this method because the field defaults to the
         * following:
         * ```java
         * JsonValue.from("message")
         * ```
         *
         * This method is primarily for setting the field to an undocumented or not yet supported
         * value.
         */
        fun type(type: JsonValue) = apply { this.type = type }

        /**
         * Billing and rate-limit usage.
         *
         * Anthropic's API bills and rate-limits by token counts, as tokens represent the underlying
         * cost to our systems.
         *
         * Under the hood, the API transforms requests into a format suitable for the model. The
         * model's output then goes through a parsing stage before becoming an API response. As a
         * result, the token counts in `usage` will not match one-to-one with the exact visible
         * content of an API request or response.
         *
         * For example, `output_tokens` will be non-zero, even for an empty string response from
         * Claude.
         *
         * Total input tokens in a request is the summation of `input_tokens`,
         * `cache_creation_input_tokens`, and `cache_read_input_tokens`.
         */
        fun usage(usage: BetaUsage) = usage(JsonField.of(usage))

        /**
         * Sets [Builder.usage] to an arbitrary JSON value.
         *
         * You should usually call [Builder.usage] with a well-typed [BetaUsage] value instead. This
         * method is primarily for setting the field to an undocumented or not yet supported value.
         */
        fun usage(usage: JsonField<BetaUsage>) = apply { this.usage = usage }

        fun additionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.clear()
            putAllAdditionalProperties(additionalProperties)
        }

        fun putAdditionalProperty(key: String, value: JsonValue) = apply {
            additionalProperties.put(key, value)
        }

        fun putAllAdditionalProperties(additionalProperties: Map<String, JsonValue>) = apply {
            this.additionalProperties.putAll(additionalProperties)
        }

        fun removeAdditionalProperty(key: String) = apply { additionalProperties.remove(key) }

        fun removeAllAdditionalProperties(keys: Set<String>) = apply {
            keys.forEach(::removeAdditionalProperty)
        }

        /**
         * Returns an immutable instance of [BetaMessage].
         *
         * Further updates to this [Builder] will not mutate the returned instance.
         *
         * The following fields are required:
         * ```java
         * .id()
         * .content()
         * .model()
         * .stopReason()
         * .stopSequence()
         * .usage()
         * ```
         *
         * @throws IllegalStateException if any required field is unset.
         */
        fun build(): BetaMessage =
            BetaMessage(
                checkRequired("id", id),
                checkRequired("content", content).map { it.toImmutable() },
                checkRequired("model", model),
                role,
                checkRequired("stopReason", stopReason),
                checkRequired("stopSequence", stopSequence),
                type,
                checkRequired("usage", usage),
                additionalProperties.toMutableMap(),
            )
    }

    private var validated: Boolean = false

    fun validate(): BetaMessage = apply {
        if (validated) {
            return@apply
        }

        id()
        content().forEach { it.validate() }
        model()
        _role().let {
            if (it != JsonValue.from("assistant")) {
                throw AnthropicInvalidDataException("'role' is invalid, received $it")
            }
        }
        stopReason().ifPresent { it.validate() }
        stopSequence()
        _type().let {
            if (it != JsonValue.from("message")) {
                throw AnthropicInvalidDataException("'type' is invalid, received $it")
            }
        }
        usage().validate()
        validated = true
    }

    fun isValid(): Boolean =
        try {
            validate()
            true
        } catch (e: AnthropicInvalidDataException) {
            false
        }

    /**
     * Returns a score indicating how many valid values are contained in this object recursively.
     *
     * Used for best match union deserialization.
     */
    @JvmSynthetic
    internal fun validity(): Int =
        (if (id.asKnown().isPresent) 1 else 0) +
            (content.asKnown().getOrNull()?.sumOf { it.validity().toInt() } ?: 0) +
            (if (model.asKnown().isPresent) 1 else 0) +
            role.let { if (it == JsonValue.from("assistant")) 1 else 0 } +
            (stopReason.asKnown().getOrNull()?.validity() ?: 0) +
            (if (stopSequence.asKnown().isPresent) 1 else 0) +
            type.let { if (it == JsonValue.from("message")) 1 else 0 } +
            (usage.asKnown().getOrNull()?.validity() ?: 0)

    override fun equals(other: Any?): Boolean {
        if (this === other) {
            return true
        }

        return /* spotless:off */ other is BetaMessage && id == other.id && content == other.content && model == other.model && role == other.role && stopReason == other.stopReason && stopSequence == other.stopSequence && type == other.type && usage == other.usage && additionalProperties == other.additionalProperties /* spotless:on */
    }

    /* spotless:off */
    private val hashCode: Int by lazy { Objects.hash(id, content, model, role, stopReason, stopSequence, type, usage, additionalProperties) }
    /* spotless:on */

    override fun hashCode(): Int = hashCode

    override fun toString() =
        "BetaMessage{id=$id, content=$content, model=$model, role=$role, stopReason=$stopReason, stopSequence=$stopSequence, type=$type, usage=$usage, additionalProperties=$additionalProperties}"
}
