/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.TelemetryRecord;
import java.util.Date;

@SdkInternalApi
public class TelemetryRecordMarshaller {
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> SEGMENTSRECEIVEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsReceivedCount").build();
    private static final MarshallingInfo<Integer> SEGMENTSSENTCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsSentCount").build();
    private static final MarshallingInfo<Integer> SEGMENTSSPILLOVERCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsSpilloverCount").build();
    private static final MarshallingInfo<Integer> SEGMENTSREJECTEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SegmentsRejectedCount").build();
    private static final MarshallingInfo<StructuredPojo> BACKENDCONNECTIONERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackendConnectionErrors").build();
    private static final TelemetryRecordMarshaller instance = new TelemetryRecordMarshaller();

    public static TelemetryRecordMarshaller getInstance() {
        return instance;
    }

    public void marshall(TelemetryRecord telemetryRecord, ProtocolMarshaller protocolMarshaller) {
        if (telemetryRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)telemetryRecord.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.getSegmentsReceivedCount(), SEGMENTSRECEIVEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.getSegmentsSentCount(), SEGMENTSSENTCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.getSegmentsSpilloverCount(), SEGMENTSSPILLOVERCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.getSegmentsRejectedCount(), SEGMENTSREJECTEDCOUNT_BINDING);
            protocolMarshaller.marshall((Object)telemetryRecord.getBackendConnectionErrors(), BACKENDCONNECTIONERRORS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

