/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.FieldToMatch;
import com.amazonaws.services.wafv2.model.PositionalConstraint;
import com.amazonaws.services.wafv2.model.TextTransformation;
import com.amazonaws.services.wafv2.model.transform.ByteMatchStatementMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ByteMatchStatement
implements Serializable,
Cloneable,
StructuredPojo {
    private ByteBuffer searchString;
    private FieldToMatch fieldToMatch;
    private List<TextTransformation> textTransformations;
    private String positionalConstraint;

    public void setSearchString(ByteBuffer searchString) {
        this.searchString = searchString;
    }

    public ByteBuffer getSearchString() {
        return this.searchString;
    }

    public ByteMatchStatement withSearchString(ByteBuffer searchString) {
        this.setSearchString(searchString);
        return this;
    }

    public void setFieldToMatch(FieldToMatch fieldToMatch) {
        this.fieldToMatch = fieldToMatch;
    }

    public FieldToMatch getFieldToMatch() {
        return this.fieldToMatch;
    }

    public ByteMatchStatement withFieldToMatch(FieldToMatch fieldToMatch) {
        this.setFieldToMatch(fieldToMatch);
        return this;
    }

    public List<TextTransformation> getTextTransformations() {
        return this.textTransformations;
    }

    public void setTextTransformations(Collection<TextTransformation> textTransformations) {
        if (textTransformations == null) {
            this.textTransformations = null;
            return;
        }
        this.textTransformations = new ArrayList<TextTransformation>(textTransformations);
    }

    public ByteMatchStatement withTextTransformations(TextTransformation ... textTransformations) {
        if (this.textTransformations == null) {
            this.setTextTransformations(new ArrayList<TextTransformation>(textTransformations.length));
        }
        for (TextTransformation ele : textTransformations) {
            this.textTransformations.add(ele);
        }
        return this;
    }

    public ByteMatchStatement withTextTransformations(Collection<TextTransformation> textTransformations) {
        this.setTextTransformations(textTransformations);
        return this;
    }

    public void setPositionalConstraint(String positionalConstraint) {
        this.positionalConstraint = positionalConstraint;
    }

    public String getPositionalConstraint() {
        return this.positionalConstraint;
    }

    public ByteMatchStatement withPositionalConstraint(String positionalConstraint) {
        this.setPositionalConstraint(positionalConstraint);
        return this;
    }

    public ByteMatchStatement withPositionalConstraint(PositionalConstraint positionalConstraint) {
        this.positionalConstraint = positionalConstraint.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSearchString() != null) {
            sb.append("SearchString: ").append(this.getSearchString()).append(",");
        }
        if (this.getFieldToMatch() != null) {
            sb.append("FieldToMatch: ").append(this.getFieldToMatch()).append(",");
        }
        if (this.getTextTransformations() != null) {
            sb.append("TextTransformations: ").append(this.getTextTransformations()).append(",");
        }
        if (this.getPositionalConstraint() != null) {
            sb.append("PositionalConstraint: ").append(this.getPositionalConstraint());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchStatement)) {
            return false;
        }
        ByteMatchStatement other = (ByteMatchStatement)obj;
        if (other.getSearchString() == null ^ this.getSearchString() == null) {
            return false;
        }
        if (other.getSearchString() != null && !other.getSearchString().equals(this.getSearchString())) {
            return false;
        }
        if (other.getFieldToMatch() == null ^ this.getFieldToMatch() == null) {
            return false;
        }
        if (other.getFieldToMatch() != null && !other.getFieldToMatch().equals(this.getFieldToMatch())) {
            return false;
        }
        if (other.getTextTransformations() == null ^ this.getTextTransformations() == null) {
            return false;
        }
        if (other.getTextTransformations() != null && !other.getTextTransformations().equals(this.getTextTransformations())) {
            return false;
        }
        if (other.getPositionalConstraint() == null ^ this.getPositionalConstraint() == null) {
            return false;
        }
        return other.getPositionalConstraint() == null || other.getPositionalConstraint().equals(this.getPositionalConstraint());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSearchString() == null ? 0 : this.getSearchString().hashCode());
        hashCode = 31 * hashCode + (this.getFieldToMatch() == null ? 0 : this.getFieldToMatch().hashCode());
        hashCode = 31 * hashCode + (this.getTextTransformations() == null ? 0 : this.getTextTransformations().hashCode());
        hashCode = 31 * hashCode + (this.getPositionalConstraint() == null ? 0 : this.getPositionalConstraint().hashCode());
        return hashCode;
    }

    public ByteMatchStatement clone() {
        try {
            return (ByteMatchStatement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ByteMatchStatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

