/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.UpdateWebACLRequest;
import com.amazonaws.services.waf.model.WebACLUpdate;
import com.amazonaws.services.waf.model.transform.WafActionJsonMarshaller;
import com.amazonaws.services.waf.model.transform.WebACLUpdateJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class UpdateWebACLRequestMarshaller
implements Marshaller<Request<UpdateWebACLRequest>, UpdateWebACLRequest> {
    public Request<UpdateWebACLRequest> marshall(UpdateWebACLRequest updateWebACLRequest) {
        if (updateWebACLRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateWebACLRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.UpdateWebACL");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<WebACLUpdate> updatesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateWebACLRequest.getWebACLId() != null) {
                jsonWriter.key("WebACLId").value((Object)updateWebACLRequest.getWebACLId());
            }
            if (updateWebACLRequest.getChangeToken() != null) {
                jsonWriter.key("ChangeToken").value((Object)updateWebACLRequest.getChangeToken());
            }
            if ((updatesList = updateWebACLRequest.getUpdates()) != null) {
                jsonWriter.key("Updates");
                jsonWriter.array();
                for (WebACLUpdate updatesListValue : updatesList) {
                    if (updatesListValue == null) continue;
                    WebACLUpdateJsonMarshaller.getInstance().marshall(updatesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateWebACLRequest.getDefaultAction() != null) {
                jsonWriter.key("DefaultAction");
                WafActionJsonMarshaller.getInstance().marshall(updateWebACLRequest.getDefaultAction(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

