/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AssumeRoleRequestMarshaller
implements Marshaller<Request<AssumeRoleRequest>, AssumeRoleRequest> {
    public Request<AssumeRoleRequest> marshall(AssumeRoleRequest assumeRoleRequest) {
        if (assumeRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)assumeRoleRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "AssumeRole");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)assumeRoleRequest.getRoleArn()));
        }
        if (assumeRoleRequest.getRoleSessionName() != null) {
            request.addParameter("RoleSessionName", StringUtils.fromString((String)assumeRoleRequest.getRoleSessionName()));
        }
        if (assumeRoleRequest.getPolicy() != null) {
            request.addParameter("Policy", StringUtils.fromString((String)assumeRoleRequest.getPolicy()));
        }
        if (assumeRoleRequest.getDurationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)assumeRoleRequest.getDurationSeconds()));
        }
        if (assumeRoleRequest.getExternalId() != null) {
            request.addParameter("ExternalId", StringUtils.fromString((String)assumeRoleRequest.getExternalId()));
        }
        if (assumeRoleRequest.getSerialNumber() != null) {
            request.addParameter("SerialNumber", StringUtils.fromString((String)assumeRoleRequest.getSerialNumber()));
        }
        if (assumeRoleRequest.getTokenCode() != null) {
            request.addParameter("TokenCode", StringUtils.fromString((String)assumeRoleRequest.getTokenCode()));
        }
        return request;
    }
}

