/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.conditions;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.stepfunctions.builder.conditions.AndCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.BinaryConditionBuilder;
import com.amazonaws.services.stepfunctions.builder.conditions.BooleanEqualsCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.BooleanEqualsPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.Condition;
import com.amazonaws.services.stepfunctions.builder.conditions.IsBooleanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.IsNullCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.IsNumericCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.IsPresentCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.IsStringCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.IsTimestampCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NotCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericEqualsCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericEqualsPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericGreaterThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericGreaterThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericGreaterThanOrEqualPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericGreaterThanPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericLessThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericLessThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericLessThanOrEqualPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NumericLessThanPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.OrCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringEqualsCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringEqualsPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringGreaterThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringGreaterThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringGreaterThanOrEqualPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringGreaterThanPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringLessThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringLessThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringLessThanOrEqualPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringLessThanPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.StringMatchesCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampEqualsCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampEqualsPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampGreaterThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampGreaterThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampGreaterThanOrEqualPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampGreaterThanPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampLessThanCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampLessThanOrEqualCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampLessThanOrEqualPathCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.TimestampLessThanPathCondition;
import com.fasterxml.jackson.databind.JsonNode;

@SdkInternalApi
public class ConditionDeserializer {
    public Condition.Builder deserializeCondition(JsonNode node) {
        if (node.has("Variable")) {
            if (node.has("StringEquals")) {
                return this.deserializeBinaryCondition(StringEqualsCondition.builder(), node);
            }
            if (node.has("StringGreaterThan")) {
                return this.deserializeBinaryCondition(StringGreaterThanCondition.builder(), node);
            }
            if (node.has("StringGreaterThanEquals")) {
                return this.deserializeBinaryCondition(StringGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("StringLessThan")) {
                return this.deserializeBinaryCondition(StringLessThanCondition.builder(), node);
            }
            if (node.has("StringLessThanEquals")) {
                return this.deserializeBinaryCondition(StringLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("StringEqualsPath")) {
                return this.deserializeBinaryCondition(StringEqualsPathCondition.builder(), node);
            }
            if (node.has("StringGreaterThanPath")) {
                return this.deserializeBinaryCondition(StringGreaterThanPathCondition.builder(), node);
            }
            if (node.has("StringGreaterThanEqualsPath")) {
                return this.deserializeBinaryCondition(StringGreaterThanOrEqualPathCondition.builder(), node);
            }
            if (node.has("StringLessThanPath")) {
                return this.deserializeBinaryCondition(StringLessThanPathCondition.builder(), node);
            }
            if (node.has("StringLessThanEqualsPath")) {
                return this.deserializeBinaryCondition(StringLessThanOrEqualPathCondition.builder(), node);
            }
            if (node.has("TimestampEquals")) {
                return this.deserializeBinaryCondition(TimestampEqualsCondition.builder(), node);
            }
            if (node.has("TimestampGreaterThan")) {
                return this.deserializeBinaryCondition(TimestampGreaterThanCondition.builder(), node);
            }
            if (node.has("TimestampGreaterThanEquals")) {
                return this.deserializeBinaryCondition(TimestampGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("TimestampLessThan")) {
                return this.deserializeBinaryCondition(TimestampLessThanCondition.builder(), node);
            }
            if (node.has("TimestampLessThanEquals")) {
                return this.deserializeBinaryCondition(TimestampLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("TimestampEqualsPath")) {
                return this.deserializeBinaryCondition(TimestampEqualsPathCondition.builder(), node);
            }
            if (node.has("TimestampGreaterThanPath")) {
                return this.deserializeBinaryCondition(TimestampGreaterThanPathCondition.builder(), node);
            }
            if (node.has("TimestampGreaterThanEqualsPath")) {
                return this.deserializeBinaryCondition(TimestampGreaterThanOrEqualPathCondition.builder(), node);
            }
            if (node.has("TimestampLessThanPath")) {
                return this.deserializeBinaryCondition(TimestampLessThanPathCondition.builder(), node);
            }
            if (node.has("TimestampLessThanEqualsPath")) {
                return this.deserializeBinaryCondition(TimestampLessThanOrEqualPathCondition.builder(), node);
            }
            if (node.has("NumericEquals")) {
                return this.deserializeBinaryCondition(NumericEqualsCondition.builder(), node);
            }
            if (node.has("NumericGreaterThan")) {
                return this.deserializeBinaryCondition(NumericGreaterThanCondition.builder(), node);
            }
            if (node.has("NumericGreaterThanEquals")) {
                return this.deserializeBinaryCondition(NumericGreaterThanOrEqualCondition.builder(), node);
            }
            if (node.has("NumericLessThan")) {
                return this.deserializeBinaryCondition(NumericLessThanCondition.builder(), node);
            }
            if (node.has("NumericLessThanEquals")) {
                return this.deserializeBinaryCondition(NumericLessThanOrEqualCondition.builder(), node);
            }
            if (node.has("NumericEqualsPath")) {
                return this.deserializeBinaryCondition(NumericEqualsPathCondition.builder(), node);
            }
            if (node.has("NumericGreaterThanPath")) {
                return this.deserializeBinaryCondition(NumericGreaterThanPathCondition.builder(), node);
            }
            if (node.has("NumericGreaterThanEqualsPath")) {
                return this.deserializeBinaryCondition(NumericGreaterThanOrEqualPathCondition.builder(), node);
            }
            if (node.has("NumericLessThanPath")) {
                return this.deserializeBinaryCondition(NumericLessThanPathCondition.builder(), node);
            }
            if (node.has("NumericLessThanEqualsPath")) {
                return this.deserializeBinaryCondition(NumericLessThanOrEqualPathCondition.builder(), node);
            }
            if (node.has("BooleanEquals")) {
                return this.deserializeBinaryCondition(BooleanEqualsCondition.builder(), node);
            }
            if (node.has("BooleanEqualsPath")) {
                return this.deserializeBinaryCondition(BooleanEqualsPathCondition.builder(), node);
            }
            if (node.has("IsNull")) {
                return this.deserializeBinaryCondition(IsNullCondition.builder(), node);
            }
            if (node.has("IsPresent")) {
                return this.deserializeBinaryCondition(IsPresentCondition.builder(), node);
            }
            if (node.has("IsString")) {
                return this.deserializeBinaryCondition(IsStringCondition.builder(), node);
            }
            if (node.has("IsNumeric")) {
                return this.deserializeBinaryCondition(IsNumericCondition.builder(), node);
            }
            if (node.has("IsTimestamp")) {
                return this.deserializeBinaryCondition(IsTimestampCondition.builder(), node);
            }
            if (node.has("IsBoolean")) {
                return this.deserializeBinaryCondition(IsBooleanCondition.builder(), node);
            }
            if (node.has("StringMatches")) {
                return this.deserializeBinaryCondition(StringMatchesCondition.builder(), node);
            }
        } else {
            if (node.has("And")) {
                AndCondition.Builder builder = AndCondition.builder();
                for (JsonNode inner : node.get("And")) {
                    builder.condition(this.deserializeCondition(inner));
                }
                return builder;
            }
            if (node.has("Or")) {
                OrCondition.Builder builder = OrCondition.builder();
                for (JsonNode inner : node.get("Or")) {
                    builder.condition(this.deserializeCondition(inner));
                }
                return builder;
            }
            if (node.has("Not")) {
                return NotCondition.builder().condition(this.deserializeCondition(node.get("Not")));
            }
        }
        throw new SdkClientException("Condition must be provided");
    }

    private Condition.Builder deserializeBinaryCondition(BinaryConditionBuilder builder, JsonNode node) {
        return builder.variable(node.get("Variable").asText()).expectedValue(node.get(builder.type()));
    }
}

