/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.CommandFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListCommandsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CommandFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListCommandsRequestMarshaller
implements Marshaller<Request<ListCommandsRequest>, ListCommandsRequest> {
    public Request<ListCommandsRequest> marshall(ListCommandsRequest listCommandsRequest) {
        if (listCommandsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listCommandsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListCommands");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList filtersList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (listCommandsRequest.getCommandId() != null) {
                jsonWriter.key("CommandId").value((Object)listCommandsRequest.getCommandId());
            }
            if (listCommandsRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value((Object)listCommandsRequest.getInstanceId());
            }
            if (listCommandsRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value((Object)listCommandsRequest.getMaxResults());
            }
            if (listCommandsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value((Object)listCommandsRequest.getNextToken());
            }
            if (!(filtersList = (SdkInternalList)listCommandsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
                jsonWriter.key("Filters");
                jsonWriter.array();
                for (CommandFilter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    CommandFilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

