/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.ReceiptAction;
import com.amazonaws.services.simpleemail.model.TlsPolicy;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ReceiptRule
implements Serializable,
Cloneable {
    private String name;
    private Boolean enabled;
    private String tlsPolicy;
    private SdkInternalList<String> recipients;
    private SdkInternalList<ReceiptAction> actions;
    private Boolean scanEnabled;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ReceiptRule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public ReceiptRule withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setTlsPolicy(String tlsPolicy) {
        this.tlsPolicy = tlsPolicy;
    }

    public String getTlsPolicy() {
        return this.tlsPolicy;
    }

    public ReceiptRule withTlsPolicy(String tlsPolicy) {
        this.setTlsPolicy(tlsPolicy);
        return this;
    }

    public void setTlsPolicy(TlsPolicy tlsPolicy) {
        this.tlsPolicy = tlsPolicy.toString();
    }

    public ReceiptRule withTlsPolicy(TlsPolicy tlsPolicy) {
        this.setTlsPolicy(tlsPolicy);
        return this;
    }

    public List<String> getRecipients() {
        if (this.recipients == null) {
            this.recipients = new SdkInternalList();
        }
        return this.recipients;
    }

    public void setRecipients(Collection<String> recipients) {
        if (recipients == null) {
            this.recipients = null;
            return;
        }
        this.recipients = new SdkInternalList(recipients);
    }

    public ReceiptRule withRecipients(String ... recipients) {
        if (this.recipients == null) {
            this.setRecipients((Collection<String>)new SdkInternalList(recipients.length));
        }
        for (String ele : recipients) {
            this.recipients.add((Object)ele);
        }
        return this;
    }

    public ReceiptRule withRecipients(Collection<String> recipients) {
        this.setRecipients(recipients);
        return this;
    }

    public List<ReceiptAction> getActions() {
        if (this.actions == null) {
            this.actions = new SdkInternalList();
        }
        return this.actions;
    }

    public void setActions(Collection<ReceiptAction> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new SdkInternalList(actions);
    }

    public ReceiptRule withActions(ReceiptAction ... actions) {
        if (this.actions == null) {
            this.setActions((Collection<ReceiptAction>)new SdkInternalList(actions.length));
        }
        for (ReceiptAction ele : actions) {
            this.actions.add((Object)ele);
        }
        return this;
    }

    public ReceiptRule withActions(Collection<ReceiptAction> actions) {
        this.setActions(actions);
        return this;
    }

    public void setScanEnabled(Boolean scanEnabled) {
        this.scanEnabled = scanEnabled;
    }

    public Boolean getScanEnabled() {
        return this.scanEnabled;
    }

    public ReceiptRule withScanEnabled(Boolean scanEnabled) {
        this.setScanEnabled(scanEnabled);
        return this;
    }

    public Boolean isScanEnabled() {
        return this.scanEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: " + this.getEnabled() + ",");
        }
        if (this.getTlsPolicy() != null) {
            sb.append("TlsPolicy: " + this.getTlsPolicy() + ",");
        }
        if (this.getRecipients() != null) {
            sb.append("Recipients: " + this.getRecipients() + ",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: " + this.getActions() + ",");
        }
        if (this.getScanEnabled() != null) {
            sb.append("ScanEnabled: " + this.getScanEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptRule)) {
            return false;
        }
        ReceiptRule other = (ReceiptRule)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getTlsPolicy() == null ^ this.getTlsPolicy() == null) {
            return false;
        }
        if (other.getTlsPolicy() != null && !other.getTlsPolicy().equals(this.getTlsPolicy())) {
            return false;
        }
        if (other.getRecipients() == null ^ this.getRecipients() == null) {
            return false;
        }
        if (other.getRecipients() != null && !other.getRecipients().equals(this.getRecipients())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getScanEnabled() == null ^ this.getScanEnabled() == null) {
            return false;
        }
        return other.getScanEnabled() == null || other.getScanEnabled().equals(this.getScanEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getTlsPolicy() == null ? 0 : this.getTlsPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getRecipients() == null ? 0 : this.getRecipients().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getScanEnabled() == null ? 0 : this.getScanEnabled().hashCode());
        return hashCode;
    }

    public ReceiptRule clone() {
        try {
            return (ReceiptRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

