/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.RdsCustomClusterConfiguration;
import com.amazonaws.services.rds.model.RestoreDBClusterFromSnapshotRequest;
import com.amazonaws.services.rds.model.ScalingConfiguration;
import com.amazonaws.services.rds.model.ServerlessV2ScalingConfiguration;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RestoreDBClusterFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromSnapshotRequest>, RestoreDBClusterFromSnapshotRequest> {
    public Request<RestoreDBClusterFromSnapshotRequest> marshall(RestoreDBClusterFromSnapshotRequest restoreDBClusterFromSnapshotRequest) {
        RdsCustomClusterConfiguration rdsCustomClusterConfiguration;
        ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
        ScalingConfiguration scalingConfiguration;
        if (restoreDBClusterFromSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBClusterFromSnapshotRequest, "AmazonRDS");
        request.addParameter("Action", "RestoreDBClusterFromSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (!restoreDBClusterFromSnapshotRequest.getAvailabilityZones().isEmpty() || !((SdkInternalList)restoreDBClusterFromSnapshotRequest.getAvailabilityZones()).isAutoConstruct()) {
            SdkInternalList availabilityZonesList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.getAvailabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getEngine()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getEngineVersion()));
        }
        if (restoreDBClusterFromSnapshotRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBClusterFromSnapshotRequest.getPort()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDatabaseName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getOptionGroupName()));
        }
        if (!restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (!restoreDBClusterFromSnapshotRequest.getTags().isEmpty() || !((SdkInternalList)restoreDBClusterFromSnapshotRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getKmsKeyId()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (restoreDBClusterFromSnapshotRequest.getBacktrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringUtils.fromLong((Long)restoreDBClusterFromSnapshotRequest.getBacktrackWindow()));
        }
        if (!restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports().isEmpty() || !((SdkInternalList)restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports()).isAutoConstruct()) {
            SdkInternalList enableCloudwatchLogsExportsList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getEngineMode() != null) {
            request.addParameter("EngineMode", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getEngineMode()));
        }
        if ((scalingConfiguration = restoreDBClusterFromSnapshotRequest.getScalingConfiguration()) != null) {
            if (scalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ScalingConfiguration.MinCapacity", StringUtils.fromInteger((Integer)scalingConfiguration.getMinCapacity()));
            }
            if (scalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ScalingConfiguration.MaxCapacity", StringUtils.fromInteger((Integer)scalingConfiguration.getMaxCapacity()));
            }
            if (scalingConfiguration.getAutoPause() != null) {
                request.addParameter("ScalingConfiguration.AutoPause", StringUtils.fromBoolean((Boolean)scalingConfiguration.getAutoPause()));
            }
            if (scalingConfiguration.getSecondsUntilAutoPause() != null) {
                request.addParameter("ScalingConfiguration.SecondsUntilAutoPause", StringUtils.fromInteger((Integer)scalingConfiguration.getSecondsUntilAutoPause()));
            }
            if (scalingConfiguration.getTimeoutAction() != null) {
                request.addParameter("ScalingConfiguration.TimeoutAction", StringUtils.fromString((String)scalingConfiguration.getTimeoutAction()));
            }
            if (scalingConfiguration.getSecondsBeforeTimeout() != null) {
                request.addParameter("ScalingConfiguration.SecondsBeforeTimeout", StringUtils.fromInteger((Integer)scalingConfiguration.getSecondsBeforeTimeout()));
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBClusterParameterGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.getDeletionProtection()));
        }
        if (restoreDBClusterFromSnapshotRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.getCopyTagsToSnapshot()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDomain()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDomainIAMRoleName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterInstanceClass() != null) {
            request.addParameter("DBClusterInstanceClass", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getDBClusterInstanceClass()));
        }
        if (restoreDBClusterFromSnapshotRequest.getStorageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getStorageType()));
        }
        if (restoreDBClusterFromSnapshotRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)restoreDBClusterFromSnapshotRequest.getIops()));
        }
        if (restoreDBClusterFromSnapshotRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreDBClusterFromSnapshotRequest.getPubliclyAccessible()));
        }
        if ((serverlessV2ScalingConfiguration = restoreDBClusterFromSnapshotRequest.getServerlessV2ScalingConfiguration()) != null) {
            if (serverlessV2ScalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ServerlessV2ScalingConfiguration.MinCapacity", StringUtils.fromDouble((Double)serverlessV2ScalingConfiguration.getMinCapacity()));
            }
            if (serverlessV2ScalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ServerlessV2ScalingConfiguration.MaxCapacity", StringUtils.fromDouble((Double)serverlessV2ScalingConfiguration.getMaxCapacity()));
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getNetworkType() != null) {
            request.addParameter("NetworkType", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getNetworkType()));
        }
        if ((rdsCustomClusterConfiguration = restoreDBClusterFromSnapshotRequest.getRdsCustomClusterConfiguration()) != null) {
            if (rdsCustomClusterConfiguration.getInterconnectSubnetId() != null) {
                request.addParameter("RdsCustomClusterConfiguration.InterconnectSubnetId", StringUtils.fromString((String)rdsCustomClusterConfiguration.getInterconnectSubnetId()));
            }
            if (rdsCustomClusterConfiguration.getTransitGatewayMulticastDomainId() != null) {
                request.addParameter("RdsCustomClusterConfiguration.TransitGatewayMulticastDomainId", StringUtils.fromString((String)rdsCustomClusterConfiguration.getTransitGatewayMulticastDomainId()));
            }
            if (rdsCustomClusterConfiguration.getReplicaMode() != null) {
                request.addParameter("RdsCustomClusterConfiguration.ReplicaMode", StringUtils.fromString((String)rdsCustomClusterConfiguration.getReplicaMode()));
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getEngineLifecycleSupport() != null) {
            request.addParameter("EngineLifecycleSupport", StringUtils.fromString((String)restoreDBClusterFromSnapshotRequest.getEngineLifecycleSupport()));
        }
        return request;
    }
}

