/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.qldb.model.KinesisConfiguration;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class StreamJournalToKinesisRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String ledgerName;
    private String roleArn;
    private Map<String, String> tags;
    private Date inclusiveStartTime;
    private Date exclusiveEndTime;
    private KinesisConfiguration kinesisConfiguration;
    private String streamName;

    public void setLedgerName(String ledgerName) {
        this.ledgerName = ledgerName;
    }

    public String getLedgerName() {
        return this.ledgerName;
    }

    public StreamJournalToKinesisRequest withLedgerName(String ledgerName) {
        this.setLedgerName(ledgerName);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public StreamJournalToKinesisRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public StreamJournalToKinesisRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public StreamJournalToKinesisRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public StreamJournalToKinesisRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setInclusiveStartTime(Date inclusiveStartTime) {
        this.inclusiveStartTime = inclusiveStartTime;
    }

    public Date getInclusiveStartTime() {
        return this.inclusiveStartTime;
    }

    public StreamJournalToKinesisRequest withInclusiveStartTime(Date inclusiveStartTime) {
        this.setInclusiveStartTime(inclusiveStartTime);
        return this;
    }

    public void setExclusiveEndTime(Date exclusiveEndTime) {
        this.exclusiveEndTime = exclusiveEndTime;
    }

    public Date getExclusiveEndTime() {
        return this.exclusiveEndTime;
    }

    public StreamJournalToKinesisRequest withExclusiveEndTime(Date exclusiveEndTime) {
        this.setExclusiveEndTime(exclusiveEndTime);
        return this;
    }

    public void setKinesisConfiguration(KinesisConfiguration kinesisConfiguration) {
        this.kinesisConfiguration = kinesisConfiguration;
    }

    public KinesisConfiguration getKinesisConfiguration() {
        return this.kinesisConfiguration;
    }

    public StreamJournalToKinesisRequest withKinesisConfiguration(KinesisConfiguration kinesisConfiguration) {
        this.setKinesisConfiguration(kinesisConfiguration);
        return this;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public StreamJournalToKinesisRequest withStreamName(String streamName) {
        this.setStreamName(streamName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLedgerName() != null) {
            sb.append("LedgerName: ").append(this.getLedgerName()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getInclusiveStartTime() != null) {
            sb.append("InclusiveStartTime: ").append(this.getInclusiveStartTime()).append(",");
        }
        if (this.getExclusiveEndTime() != null) {
            sb.append("ExclusiveEndTime: ").append(this.getExclusiveEndTime()).append(",");
        }
        if (this.getKinesisConfiguration() != null) {
            sb.append("KinesisConfiguration: ").append(this.getKinesisConfiguration()).append(",");
        }
        if (this.getStreamName() != null) {
            sb.append("StreamName: ").append(this.getStreamName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamJournalToKinesisRequest)) {
            return false;
        }
        StreamJournalToKinesisRequest other = (StreamJournalToKinesisRequest)obj;
        if (other.getLedgerName() == null ^ this.getLedgerName() == null) {
            return false;
        }
        if (other.getLedgerName() != null && !other.getLedgerName().equals(this.getLedgerName())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getInclusiveStartTime() == null ^ this.getInclusiveStartTime() == null) {
            return false;
        }
        if (other.getInclusiveStartTime() != null && !other.getInclusiveStartTime().equals(this.getInclusiveStartTime())) {
            return false;
        }
        if (other.getExclusiveEndTime() == null ^ this.getExclusiveEndTime() == null) {
            return false;
        }
        if (other.getExclusiveEndTime() != null && !other.getExclusiveEndTime().equals(this.getExclusiveEndTime())) {
            return false;
        }
        if (other.getKinesisConfiguration() == null ^ this.getKinesisConfiguration() == null) {
            return false;
        }
        if (other.getKinesisConfiguration() != null && !other.getKinesisConfiguration().equals(this.getKinesisConfiguration())) {
            return false;
        }
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        return other.getStreamName() == null || other.getStreamName().equals(this.getStreamName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLedgerName() == null ? 0 : this.getLedgerName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getInclusiveStartTime() == null ? 0 : this.getInclusiveStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getExclusiveEndTime() == null ? 0 : this.getExclusiveEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getKinesisConfiguration() == null ? 0 : this.getKinesisConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        return hashCode;
    }

    public StreamJournalToKinesisRequest clone() {
        return (StreamJournalToKinesisRequest)super.clone();
    }
}

