/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.proton.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.proton.AWSProton;
import com.amazonaws.services.proton.model.GetComponentRequest;
import com.amazonaws.services.proton.model.GetEnvironmentRequest;
import com.amazonaws.services.proton.model.GetEnvironmentTemplateVersionRequest;
import com.amazonaws.services.proton.model.GetServiceInstanceRequest;
import com.amazonaws.services.proton.model.GetServiceRequest;
import com.amazonaws.services.proton.model.GetServiceTemplateVersionRequest;
import com.amazonaws.services.proton.waiters.ComponentDeleted;
import com.amazonaws.services.proton.waiters.ComponentDeployed;
import com.amazonaws.services.proton.waiters.EnvironmentDeployed;
import com.amazonaws.services.proton.waiters.EnvironmentTemplateVersionRegistered;
import com.amazonaws.services.proton.waiters.GetComponentFunction;
import com.amazonaws.services.proton.waiters.GetEnvironmentFunction;
import com.amazonaws.services.proton.waiters.GetEnvironmentTemplateVersionFunction;
import com.amazonaws.services.proton.waiters.GetServiceFunction;
import com.amazonaws.services.proton.waiters.GetServiceInstanceFunction;
import com.amazonaws.services.proton.waiters.GetServiceTemplateVersionFunction;
import com.amazonaws.services.proton.waiters.ServiceCreated;
import com.amazonaws.services.proton.waiters.ServiceDeleted;
import com.amazonaws.services.proton.waiters.ServiceInstanceDeployed;
import com.amazonaws.services.proton.waiters.ServicePipelineDeployed;
import com.amazonaws.services.proton.waiters.ServiceTemplateVersionRegistered;
import com.amazonaws.services.proton.waiters.ServiceUpdated;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSProtonWaiters {
    private final AWSProton client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSProtonWaiters");

    @SdkInternalApi
    public AWSProtonWaiters(AWSProton client) {
        this.client = client;
    }

    public Waiter<GetComponentRequest> componentDeployed() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetComponentFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ComponentDeployed.IsSUCCEEDEDMatcher(), new ComponentDeployed.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(999), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetServiceInstanceRequest> serviceInstanceDeployed() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetServiceInstanceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServiceInstanceDeployed.IsSUCCEEDEDMatcher(), new ServiceInstanceDeployed.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(999), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetComponentRequest> componentDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetComponentFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ComponentDeleted.IsResourceNotFoundExceptionMatcher(), new ComponentDeleted.IsDELETE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(999), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetServiceRequest> serviceCreated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetServiceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServiceCreated.IsACTIVEMatcher(), new ServiceCreated.IsCREATE_FAILED_CLEANUP_COMPLETEMatcher(), new ServiceCreated.IsCREATE_FAILED_CLEANUP_FAILEDMatcher(), new ServiceCreated.IsCREATE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(999), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetEnvironmentRequest> environmentDeployed() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetEnvironmentFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EnvironmentDeployed.IsSUCCEEDEDMatcher(), new EnvironmentDeployed.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(999), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetServiceTemplateVersionRequest> serviceTemplateVersionRegistered() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetServiceTemplateVersionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServiceTemplateVersionRegistered.IsDRAFTMatcher(), new ServiceTemplateVersionRegistered.IsPUBLISHEDMatcher(), new ServiceTemplateVersionRegistered.IsREGISTRATION_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(150), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetServiceRequest> servicePipelineDeployed() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetServiceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServicePipelineDeployed.IsSUCCEEDEDMatcher(), new ServicePipelineDeployed.IsFAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(360), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetServiceRequest> serviceUpdated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetServiceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServiceUpdated.IsACTIVEMatcher(), new ServiceUpdated.IsUPDATE_FAILED_CLEANUP_COMPLETEMatcher(), new ServiceUpdated.IsUPDATE_FAILED_CLEANUP_FAILEDMatcher(), new ServiceUpdated.IsUPDATE_FAILEDMatcher(), new ServiceUpdated.IsUPDATE_COMPLETE_CLEANUP_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(999), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetServiceRequest> serviceDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetServiceFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServiceDeleted.IsResourceNotFoundExceptionMatcher(), new ServiceDeleted.IsDELETE_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(999), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetEnvironmentTemplateVersionRequest> environmentTemplateVersionRegistered() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new GetEnvironmentTemplateVersionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EnvironmentTemplateVersionRegistered.IsDRAFTMatcher(), new EnvironmentTemplateVersionRegistered.IsPUBLISHEDMatcher(), new EnvironmentTemplateVersionRegistered.IsREGISTRATION_FAILEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(150), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(2))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

