/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pi.model.transform.PerformanceInsightsMetricMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PerformanceInsightsMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private String metric;
    private String displayName;
    private Map<String, String> dimensions;
    private Double value;

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public String getMetric() {
        return this.metric;
    }

    public PerformanceInsightsMetric withMetric(String metric) {
        this.setMetric(metric);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PerformanceInsightsMetric withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public PerformanceInsightsMetric withDimensions(Map<String, String> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public PerformanceInsightsMetric addDimensionsEntry(String key, String value) {
        if (null == this.dimensions) {
            this.dimensions = new HashMap<String, String>();
        }
        if (this.dimensions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dimensions.put(key, value);
        return this;
    }

    public PerformanceInsightsMetric clearDimensionsEntries() {
        this.dimensions = null;
        return this;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Double getValue() {
        return this.value;
    }

    public PerformanceInsightsMetric withValue(Double value) {
        this.setValue(value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetric() != null) {
            sb.append("Metric: ").append(this.getMetric()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceInsightsMetric)) {
            return false;
        }
        PerformanceInsightsMetric other = (PerformanceInsightsMetric)obj;
        if (other.getMetric() == null ^ this.getMetric() == null) {
            return false;
        }
        if (other.getMetric() != null && !other.getMetric().equals(this.getMetric())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        return other.getValue() == null || other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetric() == null ? 0 : this.getMetric().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return hashCode;
    }

    public PerformanceInsightsMetric clone() {
        try {
            return (PerformanceInsightsMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PerformanceInsightsMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

