/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pi.model.transform.ResponseResourceMetricKeyMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ResponseResourceMetricKey
implements Serializable,
Cloneable,
StructuredPojo {
    private String metric;
    private Map<String, String> dimensions;

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public String getMetric() {
        return this.metric;
    }

    public ResponseResourceMetricKey withMetric(String metric) {
        this.setMetric(metric);
        return this;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public ResponseResourceMetricKey withDimensions(Map<String, String> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public ResponseResourceMetricKey addDimensionsEntry(String key, String value) {
        if (null == this.dimensions) {
            this.dimensions = new HashMap<String, String>();
        }
        if (this.dimensions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dimensions.put(key, value);
        return this;
    }

    public ResponseResourceMetricKey clearDimensionsEntries() {
        this.dimensions = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetric() != null) {
            sb.append("Metric: ").append(this.getMetric()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseResourceMetricKey)) {
            return false;
        }
        ResponseResourceMetricKey other = (ResponseResourceMetricKey)obj;
        if (other.getMetric() == null ^ this.getMetric() == null) {
            return false;
        }
        if (other.getMetric() != null && !other.getMetric().equals(this.getMetric())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        return other.getDimensions() == null || other.getDimensions().equals(this.getDimensions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetric() == null ? 0 : this.getMetric().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        return hashCode;
    }

    public ResponseResourceMetricKey clone() {
        try {
            return (ResponseResourceMetricKey)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResponseResourceMetricKeyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

