/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptographydata.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.paymentcryptographydata.model.PinBlockFormatForPinData;
import com.amazonaws.services.paymentcryptographydata.model.PinGenerationAttributes;
import java.io.Serializable;

public class GeneratePinDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String encryptionKeyIdentifier;
    private PinGenerationAttributes generationAttributes;
    private String generationKeyIdentifier;
    private String pinBlockFormat;
    private Integer pinDataLength;
    private String primaryAccountNumber;

    public void setEncryptionKeyIdentifier(String encryptionKeyIdentifier) {
        this.encryptionKeyIdentifier = encryptionKeyIdentifier;
    }

    public String getEncryptionKeyIdentifier() {
        return this.encryptionKeyIdentifier;
    }

    public GeneratePinDataRequest withEncryptionKeyIdentifier(String encryptionKeyIdentifier) {
        this.setEncryptionKeyIdentifier(encryptionKeyIdentifier);
        return this;
    }

    public void setGenerationAttributes(PinGenerationAttributes generationAttributes) {
        this.generationAttributes = generationAttributes;
    }

    public PinGenerationAttributes getGenerationAttributes() {
        return this.generationAttributes;
    }

    public GeneratePinDataRequest withGenerationAttributes(PinGenerationAttributes generationAttributes) {
        this.setGenerationAttributes(generationAttributes);
        return this;
    }

    public void setGenerationKeyIdentifier(String generationKeyIdentifier) {
        this.generationKeyIdentifier = generationKeyIdentifier;
    }

    public String getGenerationKeyIdentifier() {
        return this.generationKeyIdentifier;
    }

    public GeneratePinDataRequest withGenerationKeyIdentifier(String generationKeyIdentifier) {
        this.setGenerationKeyIdentifier(generationKeyIdentifier);
        return this;
    }

    public void setPinBlockFormat(String pinBlockFormat) {
        this.pinBlockFormat = pinBlockFormat;
    }

    public String getPinBlockFormat() {
        return this.pinBlockFormat;
    }

    public GeneratePinDataRequest withPinBlockFormat(String pinBlockFormat) {
        this.setPinBlockFormat(pinBlockFormat);
        return this;
    }

    public GeneratePinDataRequest withPinBlockFormat(PinBlockFormatForPinData pinBlockFormat) {
        this.pinBlockFormat = pinBlockFormat.toString();
        return this;
    }

    public void setPinDataLength(Integer pinDataLength) {
        this.pinDataLength = pinDataLength;
    }

    public Integer getPinDataLength() {
        return this.pinDataLength;
    }

    public GeneratePinDataRequest withPinDataLength(Integer pinDataLength) {
        this.setPinDataLength(pinDataLength);
        return this;
    }

    public void setPrimaryAccountNumber(String primaryAccountNumber) {
        this.primaryAccountNumber = primaryAccountNumber;
    }

    public String getPrimaryAccountNumber() {
        return this.primaryAccountNumber;
    }

    public GeneratePinDataRequest withPrimaryAccountNumber(String primaryAccountNumber) {
        this.setPrimaryAccountNumber(primaryAccountNumber);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionKeyIdentifier() != null) {
            sb.append("EncryptionKeyIdentifier: ").append(this.getEncryptionKeyIdentifier()).append(",");
        }
        if (this.getGenerationAttributes() != null) {
            sb.append("GenerationAttributes: ").append(this.getGenerationAttributes()).append(",");
        }
        if (this.getGenerationKeyIdentifier() != null) {
            sb.append("GenerationKeyIdentifier: ").append(this.getGenerationKeyIdentifier()).append(",");
        }
        if (this.getPinBlockFormat() != null) {
            sb.append("PinBlockFormat: ").append(this.getPinBlockFormat()).append(",");
        }
        if (this.getPinDataLength() != null) {
            sb.append("PinDataLength: ").append(this.getPinDataLength()).append(",");
        }
        if (this.getPrimaryAccountNumber() != null) {
            sb.append("PrimaryAccountNumber: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratePinDataRequest)) {
            return false;
        }
        GeneratePinDataRequest other = (GeneratePinDataRequest)obj;
        if (other.getEncryptionKeyIdentifier() == null ^ this.getEncryptionKeyIdentifier() == null) {
            return false;
        }
        if (other.getEncryptionKeyIdentifier() != null && !other.getEncryptionKeyIdentifier().equals(this.getEncryptionKeyIdentifier())) {
            return false;
        }
        if (other.getGenerationAttributes() == null ^ this.getGenerationAttributes() == null) {
            return false;
        }
        if (other.getGenerationAttributes() != null && !other.getGenerationAttributes().equals(this.getGenerationAttributes())) {
            return false;
        }
        if (other.getGenerationKeyIdentifier() == null ^ this.getGenerationKeyIdentifier() == null) {
            return false;
        }
        if (other.getGenerationKeyIdentifier() != null && !other.getGenerationKeyIdentifier().equals(this.getGenerationKeyIdentifier())) {
            return false;
        }
        if (other.getPinBlockFormat() == null ^ this.getPinBlockFormat() == null) {
            return false;
        }
        if (other.getPinBlockFormat() != null && !other.getPinBlockFormat().equals(this.getPinBlockFormat())) {
            return false;
        }
        if (other.getPinDataLength() == null ^ this.getPinDataLength() == null) {
            return false;
        }
        if (other.getPinDataLength() != null && !other.getPinDataLength().equals(this.getPinDataLength())) {
            return false;
        }
        if (other.getPrimaryAccountNumber() == null ^ this.getPrimaryAccountNumber() == null) {
            return false;
        }
        return other.getPrimaryAccountNumber() == null || other.getPrimaryAccountNumber().equals(this.getPrimaryAccountNumber());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionKeyIdentifier() == null ? 0 : this.getEncryptionKeyIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getGenerationAttributes() == null ? 0 : this.getGenerationAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getGenerationKeyIdentifier() == null ? 0 : this.getGenerationKeyIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getPinBlockFormat() == null ? 0 : this.getPinBlockFormat().hashCode());
        hashCode = 31 * hashCode + (this.getPinDataLength() == null ? 0 : this.getPinDataLength().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryAccountNumber() == null ? 0 : this.getPrimaryAccountNumber().hashCode());
        return hashCode;
    }

    public GeneratePinDataRequest clone() {
        return (GeneratePinDataRequest)super.clone();
    }
}

