/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhuborchestrator.model.transform;

import com.amazonaws.services.migrationhuborchestrator.model.StepInput;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class StepInputJsonUnmarshaller
implements Unmarshaller<StepInput, JsonUnmarshallerContext> {
    private static StepInputJsonUnmarshaller instance;

    public StepInput unmarshall(JsonUnmarshallerContext context) throws Exception {
        StepInput stepInput = new StepInput();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("integerValue", targetDepth)) {
                    context.nextToken();
                    stepInput.setIntegerValue((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("stringValue", targetDepth)) {
                    context.nextToken();
                    stepInput.setStringValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("listOfStringsValue", targetDepth)) {
                    context.nextToken();
                    stepInput.setListOfStringsValue(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("mapOfStringValue", targetDepth)) {
                    context.nextToken();
                    stepInput.setMapOfStringValue(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return stepInput;
    }

    public static StepInputJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StepInputJsonUnmarshaller();
        }
        return instance;
    }
}

