/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mainframemodernization.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mainframemodernization.model.DataSetImportConfig;
import java.util.List;

@SdkInternalApi
public class DataSetImportConfigMarshaller {
    private static final MarshallingInfo<List> DATASETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataSets").build();
    private static final MarshallingInfo<String> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").build();
    private static final DataSetImportConfigMarshaller instance = new DataSetImportConfigMarshaller();

    public static DataSetImportConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataSetImportConfig dataSetImportConfig, ProtocolMarshaller protocolMarshaller) {
        if (dataSetImportConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataSetImportConfig.getDataSets(), DATASETS_BINDING);
            protocolMarshaller.marshall((Object)dataSetImportConfig.getS3Location(), S3LOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

