/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.logs.model.StandardUnit;
import com.amazonaws.services.logs.model.transform.MetricTransformationMarshaller;
import java.io.Serializable;
import java.util.Map;

public class MetricTransformation
implements Serializable,
Cloneable,
StructuredPojo {
    private String metricName;
    private String metricNamespace;
    private String metricValue;
    private Double defaultValue;
    private SdkInternalMap<String, String> dimensions;
    private String unit;

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public MetricTransformation withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public void setMetricNamespace(String metricNamespace) {
        this.metricNamespace = metricNamespace;
    }

    public String getMetricNamespace() {
        return this.metricNamespace;
    }

    public MetricTransformation withMetricNamespace(String metricNamespace) {
        this.setMetricNamespace(metricNamespace);
        return this;
    }

    public void setMetricValue(String metricValue) {
        this.metricValue = metricValue;
    }

    public String getMetricValue() {
        return this.metricValue;
    }

    public MetricTransformation withMetricValue(String metricValue) {
        this.setMetricValue(metricValue);
        return this;
    }

    public void setDefaultValue(Double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Double getDefaultValue() {
        return this.defaultValue;
    }

    public MetricTransformation withDefaultValue(Double defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public Map<String, String> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new SdkInternalMap();
        }
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions == null ? null : new SdkInternalMap(dimensions);
    }

    public MetricTransformation withDimensions(Map<String, String> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public MetricTransformation addDimensionsEntry(String key, String value) {
        if (null == this.dimensions) {
            this.dimensions = new SdkInternalMap();
        }
        if (this.dimensions.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dimensions.put((Object)key, (Object)value);
        return this;
    }

    public MetricTransformation clearDimensionsEntries() {
        this.dimensions = null;
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public MetricTransformation withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    public MetricTransformation withUnit(StandardUnit unit) {
        this.unit = unit.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getMetricNamespace() != null) {
            sb.append("MetricNamespace: ").append(this.getMetricNamespace()).append(",");
        }
        if (this.getMetricValue() != null) {
            sb.append("MetricValue: ").append(this.getMetricValue()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricTransformation)) {
            return false;
        }
        MetricTransformation other = (MetricTransformation)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getMetricNamespace() == null ^ this.getMetricNamespace() == null) {
            return false;
        }
        if (other.getMetricNamespace() != null && !other.getMetricNamespace().equals(this.getMetricNamespace())) {
            return false;
        }
        if (other.getMetricValue() == null ^ this.getMetricValue() == null) {
            return false;
        }
        if (other.getMetricValue() != null && !other.getMetricValue().equals(this.getMetricValue())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        return other.getUnit() == null || other.getUnit().equals(this.getUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricNamespace() == null ? 0 : this.getMetricNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricValue() == null ? 0 : this.getMetricValue().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        return hashCode;
    }

    public MetricTransformation clone() {
        try {
            return (MetricTransformation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricTransformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

