/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntime.model.IntentConfidence;
import com.amazonaws.services.lexruntime.model.transform.PredictedIntentMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PredictedIntent
implements Serializable,
Cloneable,
StructuredPojo {
    private String intentName;
    private IntentConfidence nluIntentConfidence;
    private Map<String, String> slots;

    public void setIntentName(String intentName) {
        this.intentName = intentName;
    }

    public String getIntentName() {
        return this.intentName;
    }

    public PredictedIntent withIntentName(String intentName) {
        this.setIntentName(intentName);
        return this;
    }

    public void setNluIntentConfidence(IntentConfidence nluIntentConfidence) {
        this.nluIntentConfidence = nluIntentConfidence;
    }

    public IntentConfidence getNluIntentConfidence() {
        return this.nluIntentConfidence;
    }

    public PredictedIntent withNluIntentConfidence(IntentConfidence nluIntentConfidence) {
        this.setNluIntentConfidence(nluIntentConfidence);
        return this;
    }

    public Map<String, String> getSlots() {
        return this.slots;
    }

    public void setSlots(Map<String, String> slots) {
        this.slots = slots;
    }

    public PredictedIntent withSlots(Map<String, String> slots) {
        this.setSlots(slots);
        return this;
    }

    public PredictedIntent addSlotsEntry(String key, String value) {
        if (null == this.slots) {
            this.slots = new HashMap<String, String>();
        }
        if (this.slots.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.slots.put(key, value);
        return this;
    }

    public PredictedIntent clearSlotsEntries() {
        this.slots = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIntentName() != null) {
            sb.append("IntentName: ").append(this.getIntentName()).append(",");
        }
        if (this.getNluIntentConfidence() != null) {
            sb.append("NluIntentConfidence: ").append(this.getNluIntentConfidence()).append(",");
        }
        if (this.getSlots() != null) {
            sb.append("Slots: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictedIntent)) {
            return false;
        }
        PredictedIntent other = (PredictedIntent)obj;
        if (other.getIntentName() == null ^ this.getIntentName() == null) {
            return false;
        }
        if (other.getIntentName() != null && !other.getIntentName().equals(this.getIntentName())) {
            return false;
        }
        if (other.getNluIntentConfidence() == null ^ this.getNluIntentConfidence() == null) {
            return false;
        }
        if (other.getNluIntentConfidence() != null && !other.getNluIntentConfidence().equals(this.getNluIntentConfidence())) {
            return false;
        }
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        return other.getSlots() == null || other.getSlots().equals(this.getSlots());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIntentName() == null ? 0 : this.getIntentName().hashCode());
        hashCode = 31 * hashCode + (this.getNluIntentConfidence() == null ? 0 : this.getNluIntentConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        return hashCode;
    }

    public PredictedIntent clone() {
        try {
            return (PredictedIntent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredictedIntentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

