/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceGroup;
import com.amazonaws.services.kendra.model.transform.UserContextMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserContext
implements Serializable,
Cloneable,
StructuredPojo {
    private String token;
    private String userId;
    private List<String> groups;
    private List<DataSourceGroup> dataSourceGroups;

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public UserContext withToken(String token) {
        this.setToken(token);
        return this;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserContext withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<String>(groups);
    }

    public UserContext withGroups(String ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public UserContext withGroups(Collection<String> groups) {
        this.setGroups(groups);
        return this;
    }

    public List<DataSourceGroup> getDataSourceGroups() {
        return this.dataSourceGroups;
    }

    public void setDataSourceGroups(Collection<DataSourceGroup> dataSourceGroups) {
        if (dataSourceGroups == null) {
            this.dataSourceGroups = null;
            return;
        }
        this.dataSourceGroups = new ArrayList<DataSourceGroup>(dataSourceGroups);
    }

    public UserContext withDataSourceGroups(DataSourceGroup ... dataSourceGroups) {
        if (this.dataSourceGroups == null) {
            this.setDataSourceGroups(new ArrayList<DataSourceGroup>(dataSourceGroups.length));
        }
        for (DataSourceGroup ele : dataSourceGroups) {
            this.dataSourceGroups.add(ele);
        }
        return this;
    }

    public UserContext withDataSourceGroups(Collection<DataSourceGroup> dataSourceGroups) {
        this.setDataSourceGroups(dataSourceGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getToken() != null) {
            sb.append("Token: ").append(this.getToken()).append(",");
        }
        if (this.getUserId() != null) {
            sb.append("UserId: ").append(this.getUserId()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getDataSourceGroups() != null) {
            sb.append("DataSourceGroups: ").append(this.getDataSourceGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserContext)) {
            return false;
        }
        UserContext other = (UserContext)obj;
        if (other.getToken() == null ^ this.getToken() == null) {
            return false;
        }
        if (other.getToken() != null && !other.getToken().equals(this.getToken())) {
            return false;
        }
        if (other.getUserId() == null ^ this.getUserId() == null) {
            return false;
        }
        if (other.getUserId() != null && !other.getUserId().equals(this.getUserId())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getDataSourceGroups() == null ^ this.getDataSourceGroups() == null) {
            return false;
        }
        return other.getDataSourceGroups() == null || other.getDataSourceGroups().equals(this.getDataSourceGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getToken() == null ? 0 : this.getToken().hashCode());
        hashCode = 31 * hashCode + (this.getUserId() == null ? 0 : this.getUserId().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getDataSourceGroups() == null ? 0 : this.getDataSourceGroups().hashCode());
        return hashCode;
    }

    public UserContext clone() {
        try {
            return (UserContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

