/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kafka.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.kafka.model.ConfigurationRevision;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListConfigurationRevisionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ConfigurationRevision> revisions;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListConfigurationRevisionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ConfigurationRevision> getRevisions() {
        return this.revisions;
    }

    public void setRevisions(Collection<ConfigurationRevision> revisions) {
        if (revisions == null) {
            this.revisions = null;
            return;
        }
        this.revisions = new ArrayList<ConfigurationRevision>(revisions);
    }

    public ListConfigurationRevisionsResult withRevisions(ConfigurationRevision ... revisions) {
        if (this.revisions == null) {
            this.setRevisions(new ArrayList<ConfigurationRevision>(revisions.length));
        }
        for (ConfigurationRevision ele : revisions) {
            this.revisions.add(ele);
        }
        return this;
    }

    public ListConfigurationRevisionsResult withRevisions(Collection<ConfigurationRevision> revisions) {
        this.setRevisions(revisions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRevisions() != null) {
            sb.append("Revisions: ").append(this.getRevisions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationRevisionsResult)) {
            return false;
        }
        ListConfigurationRevisionsResult other = (ListConfigurationRevisionsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRevisions() == null ^ this.getRevisions() == null) {
            return false;
        }
        return other.getRevisions() == null || other.getRevisions().equals(this.getRevisions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRevisions() == null ? 0 : this.getRevisions().hashCode());
        return hashCode;
    }

    public ListConfigurationRevisionsResult clone() {
        try {
            return (ListConfigurationRevisionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

